/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.services;

import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CockpitApiPermissionCheckerImpl
implements CockpitApiPermissionChecker {
    private final PermissionService permissionService;

    public CockpitApiPermissionCheckerImpl(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public Optional<String> checkCreatePermission(String userId, String environmentId, DeploymentMode mode) {
        if (this.isNotAllowedToCreateApi(userId, environmentId)) {
            return Optional.of("You are not allowed to create APIs on this environment.");
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> checkUpdatePermission(String userId, String environmentId, String apiId, DeploymentMode mode) {
        if (this.isNotAllowedToUpdateApi(userId, environmentId)) {
            return Optional.of("You are not allowed to update APIs on this environment.");
        }
        if (this.isNotAllowedToUpdateDocumentation(userId, apiId)) {
            return Optional.of("You are not allowed to update the documentation of this API.");
        }
        if (mode != DeploymentMode.API_DOCUMENTED && this.isNotAllowedToUpdateApiDefinition(userId, apiId)) {
            return Optional.of("You are not allowed to mock and deploy this API.");
        }
        return Optional.empty();
    }

    private boolean isNotAllowedToCreateApi(String userId, String environmentId) {
        return !this.isAdmin(userId) && !this.permissionService.hasPermission(userId, RolePermission.ENVIRONMENT_API, environmentId, RolePermissionAction.CREATE);
    }

    private boolean isNotAllowedToUpdateApi(String userId, String environmentId) {
        return !this.isAdmin(userId) && !this.permissionService.hasPermission(userId, RolePermission.ENVIRONMENT_API, environmentId, RolePermissionAction.UPDATE);
    }

    private boolean isNotAllowedToUpdateDocumentation(String userId, String apiId) {
        return !this.isAdmin(userId) && !this.permissionService.hasPermission(userId, RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.UPDATE);
    }

    private boolean isNotAllowedToUpdateApiDefinition(String userId, String apiId) {
        return !this.isAdmin(userId) && !this.permissionService.hasPermission(userId, RolePermission.API_DEFINITION, apiId, RolePermissionAction.UPDATE);
    }

    protected boolean isAdmin(String userId) {
        return this.permissionService.hasManagementRights(userId);
    }
}

