/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.ApplicationMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApplicationMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApplicationMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.service.ApplicationMetadataService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApplicationMetadataService {
    @Autowired
    private ApplicationService applicationService;

    @Override
    public List<ApplicationMetadataEntity> findAllByApplication(String applicationId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.APPLICATION, applicationId, false);
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, applicationId)).collect(Collectors.toList());
    }

    @Override
    public ApplicationMetadataEntity findByIdAndApplication(String metadataId, String applicationId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.APPLICATION, applicationId, false), applicationId);
    }

    @Override
    public void delete(String metadataId, String applicationId) {
        this.delete(metadataId, MetadataReferenceType.APPLICATION, applicationId);
    }

    @Override
    public ApplicationMetadataEntity create(String environmentId, NewApplicationMetadataEntity metadataEntity) {
        return this.convert(this.create((NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.APPLICATION, metadataEntity.getApplicationId(), false, environmentId), metadataEntity.getApplicationId());
    }

    @Override
    public ApplicationMetadataEntity update(String environmentId, UpdateApplicationMetadataEntity metadataEntity) {
        return this.convert(this.update((UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.APPLICATION, metadataEntity.getApplicationId(), false, environmentId), metadataEntity.getApplicationId());
    }

    @Override
    protected void checkReferenceMetadataFormat(MetadataFormat format, String value, MetadataReferenceType referenceType, String referenceId, String environmentId) {
        ApplicationEntity applicationEntity = this.applicationService.findById(environmentId, referenceId);
        this.metadataService.checkMetadataFormat(format, value, referenceType, applicationEntity);
    }

    private ApplicationMetadataEntity convert(ReferenceMetadataEntity m, String applicationId) {
        ApplicationMetadataEntity applicationMetadataEntity = new ApplicationMetadataEntity();
        applicationMetadataEntity.setKey(m.getKey());
        applicationMetadataEntity.setName(m.getName());
        applicationMetadataEntity.setFormat(m.getFormat());
        applicationMetadataEntity.setValue(m.getValue());
        applicationMetadataEntity.setDefaultValue(m.getDefaultValue());
        applicationMetadataEntity.setApplicationId(applicationId);
        return applicationMetadataEntity;
    }
}

