/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TaskEntity;
import io.gravitee.rest.api.model.TaskType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TaskService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.promotion.PromotionTasksService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceImpl
extends AbstractService
implements TaskService {
    private final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final int NUMBER_OF_PENDING_USERS_TO_SEARCH = 100;
    @Autowired
    private ApiService apiService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PlanService planService;
    @Autowired
    private UserService userService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private PromotionTasksService promotionTasksService;

    @Override
    public List<TaskEntity> findAll(String userId) {
        if (userId == null) {
            throw new UnauthorizedAccessException();
        }
        try {
            Page<UserEntity> pendingUsers;
            List<Object> tasks;
            Set<String> apiIds = this.getApisForAPermission(userId, ApiPermission.SUBSCRIPTION.getName());
            if (apiIds.isEmpty()) {
                tasks = new ArrayList();
            } else {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setStatuses(Collections.singleton(SubscriptionStatus.PENDING));
                query.setApis(apiIds);
                tasks = this.subscriptionService.search(query).stream().map(this::convert).collect(Collectors.toList());
            }
            if (this.isAdmin() && (pendingUsers = this.userService.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.PENDING}).build(), (Pageable)new PageableImpl(1, 100))).getContent() != null && !pendingUsers.getContent().isEmpty()) {
                tasks.addAll(pendingUsers.getContent().stream().map(this::convert).collect(Collectors.toList()));
            }
            if (!(apiIds = this.getApisForAPermission(userId, ApiPermission.REVIEWS.getName())).isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.IN_REVIEW.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            if (!(apiIds = this.getApisForAPermission(userId, ApiPermission.DEFINITION.getName())).isEmpty()) {
                apiIds.forEach(apiId -> {
                    List<Workflow> workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, (String)apiId, WorkflowType.REVIEW);
                    if (workflows != null && !workflows.isEmpty()) {
                        Workflow currentWorkflow = workflows.get(0);
                        if (WorkflowState.REQUEST_FOR_CHANGES.name().equals(currentWorkflow.getState())) {
                            tasks.add(this.convert(currentWorkflow));
                        }
                    }
                });
            }
            tasks.addAll(this.promotionTasksService.getPromotionTasks(GraviteeContext.getCurrentOrganization()));
            return tasks;
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error retrieving user tasks {}", (Object)e.getMessage());
            throw new TechnicalManagementException("Error retreiving user tasks", e);
        }
    }

    private Set<String> getApisForAPermission(String userId, String permission) throws TechnicalException {
        Set<MembershipEntity> memberships = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API);
        memberships.addAll(this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP));
        HashMap<String, RoleEntity> roleNameToEntity = new HashMap<String, RoleEntity>();
        HashSet<String> apiIds = new HashSet<String>();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (MembershipEntity membership : memberships) {
            char[] rights;
            RoleEntity role;
            RoleEntity roleEntity = (RoleEntity)roleNameToEntity.get(membership.getRoleId());
            if (roleEntity == null && !roleNameToEntity.containsKey(membership.getRoleId()) && (role = this.roleService.findById(membership.getRoleId())).getScope() == RoleScope.API) {
                roleNameToEntity.put(role.getId(), role);
                roleEntity = role;
            }
            if (roleEntity == null || (rights = (char[])roleEntity.getPermissions().get(permission)) == null) continue;
            block5: for (char c : rights) {
                if (c != 'U') continue;
                switch (membership.getReferenceType()) {
                    case GROUP: {
                        groupIds.add(membership.getReferenceId());
                        continue block5;
                    }
                    case API: {
                        apiIds.add(membership.getReferenceId());
                        continue block5;
                    }
                }
            }
        }
        if (!groupIds.isEmpty()) {
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setGroups(groupIds);
            apiIds.addAll(this.apiService.searchIds(apiQuery));
        }
        return apiIds;
    }

    @Override
    public Metadata getMetadata(List<TaskEntity> tasks) {
        Metadata metadata = new Metadata();
        tasks.forEach(task -> {
            Object data = task.getData();
            if (data instanceof SubscriptionEntity) {
                SubscriptionEntity subscription = (SubscriptionEntity)data;
                if (!metadata.containsKey(subscription.getApplication())) {
                    ApplicationEntity applicationEntity = this.applicationService.findById(GraviteeContext.getCurrentEnvironment(), subscription.getApplication());
                    metadata.put(subscription.getApplication(), "name", (Object)applicationEntity.getName());
                }
                if (!metadata.containsKey(subscription.getPlan())) {
                    PlanEntity planEntity = this.planService.findById(subscription.getPlan());
                    String apiId = planEntity.getApi();
                    ApiEntity api = this.apiService.findById(apiId);
                    metadata.put(subscription.getPlan(), "name", (Object)planEntity.getName());
                    metadata.put(subscription.getPlan(), "api", (Object)apiId);
                    metadata.put(apiId, "name", (Object)api.getName());
                }
            } else if (data instanceof Workflow) {
                Workflow workflow = (Workflow)data;
                if (WorkflowReferenceType.API.name().equals(workflow.getReferenceType()) && !metadata.containsKey(workflow.getReferenceId())) {
                    ApiEntity api = this.apiService.findById(workflow.getReferenceId());
                    metadata.put(api.getId(), "name", (Object)api.getName());
                }
            }
        });
        return metadata;
    }

    private TaskEntity convert(UserEntity user) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.USER_REGISTRATION_APPROVAL);
            taskEntity.setCreatedAt(user.getCreatedAt());
            taskEntity.setData((Object)user);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting user {} to a Task", (Object)user.getId());
            throw new TechnicalManagementException("Error converting user " + user.getId() + " to a Task", e);
        }
        return taskEntity;
    }

    private TaskEntity convert(SubscriptionEntity subscription) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.SUBSCRIPTION_APPROVAL);
            taskEntity.setCreatedAt(subscription.getCreatedAt());
            taskEntity.setData((Object)subscription);
        }
        catch (Exception e) {
            this.LOGGER.error("Error converting subscription {} to a Task", (Object)subscription.getId());
            throw new TechnicalManagementException("Error converting subscription " + subscription.getId() + " to a Task", e);
        }
        return taskEntity;
    }

    private TaskEntity convert(Workflow workflow) {
        TaskEntity taskEntity = new TaskEntity();
        try {
            taskEntity.setType(TaskType.valueOf((String)workflow.getState()));
            taskEntity.setCreatedAt(workflow.getCreatedAt());
            taskEntity.setData((Object)workflow);
        }
        catch (Exception e) {
            String error = "Error converting workflow " + workflow.getId() + " to a Task";
            this.LOGGER.error(error);
            throw new TechnicalManagementException(error, e);
        }
        return taskEntity;
    }
}

