/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.ReCaptchaService;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReCaptchaServiceImpl
implements ReCaptchaService {
    private static Logger LOGGER = LoggerFactory.getLogger(ReCaptchaServiceImpl.class);
    @Value(value="${reCaptcha.enabled:false}")
    private boolean enabled;
    @Value(value="${reCaptcha.siteKey:}")
    private String siteKey;
    @Value(value="${reCaptcha.secretKey:}")
    private String secretKey;
    @Value(value="${reCaptcha.minScore:0.5}")
    private Double minScore;
    @Value(value="${reCaptcha.serviceUrl:https://www.google.com/recaptcha/api/siteverify}")
    private String serviceUrl;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public boolean isValid(String token) {
        if (!this.isEnabled()) {
            LOGGER.debug("ReCaptchaService is disabled");
            return true;
        }
        LOGGER.debug("ReCaptchaService is enabled");
        try {
            if (token == null || "".equals(token.trim())) {
                LOGGER.info("Recaptcha token is empty");
                return false;
            }
            Buffer response = this.httpClientService.request(HttpMethod.POST, this.serviceUrl, Collections.singletonMap("Content-Type", "application/x-www-form-urlencoded"), "secret=" + this.secretKey + "&response=" + token, false);
            Map res = (Map)this.objectMapper.readValue(response.toString(), Map.class);
            Boolean success = res.getOrDefault("success", false);
            Double score = res.getOrDefault("score", 0.0);
            LOGGER.debug(String.format("ReCaptchaService success: %s score: %s", success, score));
            return success != false && score >= this.minScore;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred when trying to validate ReCaptcha token.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getSiteKey() {
        return this.siteKey;
    }
}

