/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.searcher;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.impl.search.lucene.searcher.AbstractDocumentSearcher;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentSearcher
extends AbstractDocumentSearcher {
    public static final String FIELD_API_TYPE_VALUE = "api";
    public static final String FIELD_PAGE_TYPE_VALUE = "page";
    private static final Map<String, Float> API_FIELD_BOOST = new HashMap<String, Float>(){
        {
            this.put("name", Float.valueOf(12.0f));
            this.put("name_lowercase", Float.valueOf(12.0f));
            this.put("name_split", Float.valueOf(10.0f));
            this.put("paths", Float.valueOf(10.0f));
            this.put("hosts", Float.valueOf(10.0f));
            this.put("labels", Float.valueOf(8.0f));
            this.put("description", Float.valueOf(6.0f));
            this.put("metadata", Float.valueOf(4.0f));
        }
    };
    private static final Map<String, Float> PAGE_FIELD_BOOST = new HashMap<String, Float>(){
        {
            this.put("name", Float.valueOf(1.0f));
            this.put("name_lowercase", Float.valueOf(1.0f));
            this.put("name_split", Float.valueOf(1.0f));
            this.put("content", Float.valueOf(1.0f));
        }
    };
    private static final String[] API_FIELD_SEARCH = new String[]{"id", "name", "name_lowercase", "name_split", "description", "description_lowercase", "description_split", "ownerName", "labels", "labels_split", "tags", "tags_split", "categories", "categories_split", "paths", "paths_split", "hosts", "hosts_split", "metadata", "metadata_split"};
    private static final String[] PAGE_FIELD_SEARCH = new String[]{"name", "name_lowercase", "name_split", "content", "reference_id", "reference_type"};
    private static final String[] AUTHORIZED_EXPLICIT_FILTER = new String[]{"name", "ownerName", "labels", "categories", "description"};

    @Override
    public SearchResult search(Query query) throws TechnicalException {
        BooleanQuery.Builder mainQuery = new BooleanQuery.Builder();
        try {
            String rest = this.completeQueryWithFilters(query, mainQuery);
            MultiFieldQueryParser apiParser = new MultiFieldQueryParser(API_FIELD_SEARCH, this.analyzer, API_FIELD_BOOST);
            apiParser.setFuzzyMinSim(0.6f);
            apiParser.setAllowLeadingWildcard(true);
            MultiFieldQueryParser pageParser = new MultiFieldQueryParser(PAGE_FIELD_SEARCH, this.analyzer, PAGE_FIELD_BOOST);
            pageParser.setFuzzyMinSim(0.6f);
            pageParser.setAllowLeadingWildcard(true);
            BooleanQuery.Builder pageFieldsQuery = new BooleanQuery.Builder();
            BooleanQuery.Builder apiQuery = new BooleanQuery.Builder();
            String inputQuery = QueryParserBase.escape((String)rest);
            if (!inputQuery.isEmpty()) {
                org.apache.lucene.search.Query parsePage = pageParser.parse(inputQuery);
                pageFieldsQuery.add(parsePage, BooleanClause.Occur.SHOULD);
                org.apache.lucene.search.Query parseApi = apiParser.parse(inputQuery);
                apiQuery.add((org.apache.lucene.search.Query)this.buildApiFields(rest, parseApi, BooleanClause.Occur.SHOULD), BooleanClause.Occur.MUST);
            }
            BooleanQuery envCriteria = this.buildEnvCriteria();
            apiQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_API_TYPE_VALUE)), BooleanClause.Occur.MUST).add((org.apache.lucene.search.Query)envCriteria, BooleanClause.Occur.FILTER);
            org.apache.lucene.search.Query apisFilter = this.getApisFilter("id", query.getFilters());
            if (apisFilter != null) {
                apiQuery.add(apisFilter, BooleanClause.Occur.MUST);
            }
            pageFieldsQuery.add(this.toWildcard("name", rest), BooleanClause.Occur.SHOULD).add(this.toWildcard("name_lowercase", rest.toLowerCase()), BooleanClause.Occur.SHOULD).add(this.toWildcard("content", rest), BooleanClause.Occur.SHOULD);
            BooleanQuery.Builder pageQuery = new BooleanQuery.Builder().add((org.apache.lucene.search.Query)pageFieldsQuery.build(), BooleanClause.Occur.MUST).add((org.apache.lucene.search.Query)new TermQuery(new Term("type", FIELD_PAGE_TYPE_VALUE)), BooleanClause.Occur.MUST).add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", FIELD_API_TYPE_VALUE)), BooleanClause.Occur.MUST);
            org.apache.lucene.search.Query pageApisFilter = this.getApisFilter("reference_id", query.getFilters());
            if (pageApisFilter != null) {
                pageQuery.add(pageApisFilter, BooleanClause.Occur.MUST);
            }
            mainQuery.add((org.apache.lucene.search.Query)new BoostQuery((org.apache.lucene.search.Query)apiQuery.build(), 2.0f), BooleanClause.Occur.SHOULD).add((org.apache.lucene.search.Query)pageQuery.build(), BooleanClause.Occur.SHOULD);
            if (query.getFilters() != null) {
                BooleanQuery.Builder filtersQuery = new BooleanQuery.Builder();
                boolean[] hasClause = new boolean[]{false};
                query.getFilters().forEach((field, value) -> {
                    if (!Collection.class.isAssignableFrom(value.getClass())) {
                        filtersQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(field, QueryParserBase.escape((String)((String)value)))), BooleanClause.Occur.MUST);
                        hasClause[0] = true;
                    }
                });
                if (hasClause[0]) {
                    filtersQuery.add((org.apache.lucene.search.Query)envCriteria, BooleanClause.Occur.FILTER);
                    mainQuery.add((org.apache.lucene.search.Query)filtersQuery.build(), BooleanClause.Occur.MUST);
                }
            }
            return this.search((org.apache.lucene.search.Query)mainQuery.build());
        }
        catch (ParseException pe) {
            this.logger.error("Invalid query to search for API documents", (Throwable)pe);
            throw new TechnicalException("Invalid query to search for API documents", (Throwable)pe);
        }
    }

    protected String completeQueryWithFilters(Query query, BooleanQuery.Builder mainQuery) {
        try {
            BooleanQuery.Builder restQuery = new BooleanQuery.Builder();
            Set<String> rest = this.appendExplicitFilters(query.getQuery(), mainQuery, restQuery);
            BooleanQuery build = restQuery.build();
            if (build.clauses().size() > 0) {
                mainQuery.add((org.apache.lucene.search.Query)build, ((BooleanClause)build.clauses().get(0)).getOccur());
            }
            if (rest != null) {
                return rest.stream().collect(Collectors.joining(" "));
            }
            return "";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return query.getQuery();
        }
    }

    protected Set<String> appendExplicitFilters(String query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery) throws ParseException {
        QueryParser parser = new QueryParser("", (Analyzer)new KeywordAnalyzer());
        parser.setAllowLeadingWildcard(true);
        org.apache.lucene.search.Query parse = parser.parse(query);
        if (this.hasExplicitFilter(query)) {
            return this.appendExplicitFilters(parse, mainQuery, restQuery, null);
        }
        return Collections.singleton(query);
    }

    private Set<String> appendExplicitFilters(org.apache.lucene.search.Query query, BooleanQuery.Builder mainQuery, BooleanQuery.Builder restQuery, BooleanClause clause) {
        BooleanClause.Occur currentOccur;
        HashSet<String> rest = new HashSet<String>();
        BooleanClause.Occur occur = currentOccur = clause != null ? clause.getOccur() : BooleanClause.Occur.FILTER;
        if (query instanceof TermQuery) {
            TermQuery tQuery = (TermQuery)query;
            Term term = tQuery.getTerm();
            if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
                mainQuery.add((org.apache.lucene.search.Query)new TermQuery(this.buildTermFilter(term)), currentOccur);
            } else if (clause != null) {
                restQuery.add((org.apache.lucene.search.Query)this.buildApiFields(term.text(), BooleanClause.Occur.SHOULD), clause.getOccur());
            } else {
                rest.add(term.text());
            }
        } else if (query instanceof BooleanQuery) {
            BooleanQuery bQuery = (BooleanQuery)query;
            List clauses = bQuery.clauses();
            if (!clauses.isEmpty()) {
                BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
                for (BooleanClause _clause : clauses) {
                    org.apache.lucene.search.Query innerQuery = _clause.getQuery();
                    Set<String> innerRest = this.appendExplicitFilters(innerQuery, subQuery, restQuery, _clause);
                    if (innerRest == null) {
                        return null;
                    }
                    rest.addAll(innerRest);
                }
                mainQuery.add((org.apache.lucene.search.Query)subQuery.build(), BooleanClause.Occur.FILTER);
            }
        } else if (query instanceof WildcardQuery) {
            WildcardQuery wQuery = (WildcardQuery)query;
            Term term = wQuery.getTerm();
            if (Arrays.stream(AUTHORIZED_EXPLICIT_FILTER).anyMatch(field -> field.equals(term.field()))) {
                mainQuery.add((org.apache.lucene.search.Query)wQuery, currentOccur);
            } else {
                rest.add(term.text());
            }
        } else {
            return null;
        }
        return rest;
    }

    private Term buildTermFilter(Term term) {
        if ("categories".equals(term.field())) {
            return new Term(term.field(), ApiDocumentSearcher.formatCategoryField(term.text()));
        }
        return new Term(term.field() + "_lowercase", term.text().toLowerCase());
    }

    public static String formatCategoryField(String category) {
        return category.toLowerCase().replaceAll(" ", "-");
    }

    private org.apache.lucene.search.Query toWildcard(String field, String query) {
        return new WildcardQuery(new Term(field, "*" + query + "*"));
    }

    private BooleanQuery buildApiFields(String query, BooleanClause.Occur occur) {
        return this.buildApiFields(query, null, occur);
    }

    private BooleanQuery buildApiFields(String query, org.apache.lucene.search.Query queryParsed, BooleanClause.Occur occur) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (queryParsed != null) {
            builder.add(queryParsed, occur);
        }
        return builder.add(this.toWildcard("name", query), occur).add(this.toWildcard("name_lowercase", query.toLowerCase()), occur).add(this.toWildcard("paths", query), occur).add(this.toWildcard("description", query), occur).add(this.toWildcard("description_lowercase", query.toLowerCase()), occur).add(this.toWildcard("hosts", query), occur).add(this.toWildcard("labels", query), occur).add(this.toWildcard("categories", query), occur).add(this.toWildcard("tags", query), occur).add(this.toWildcard("metadata", query), occur).build();
    }

    private BooleanQuery buildEnvCriteria() {
        return new BooleanQuery.Builder().add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_type", GraviteeContext.ReferenceContextType.ENVIRONMENT.name())), BooleanClause.Occur.MUST).add((org.apache.lucene.search.Query)new TermQuery(new Term("reference_id", GraviteeContext.getCurrentEnvironmentOrDefault())), BooleanClause.Occur.MUST).build();
    }

    private org.apache.lucene.search.Query getApisFilter(String field, Map<String, Object> filters) {
        Object filter = filters.get(FIELD_API_TYPE_VALUE);
        if (filter != null) {
            BooleanQuery.Builder filterApisQuery = new BooleanQuery.Builder();
            ((Collection)filter).stream().forEach(value1 -> filterApisQuery.add((org.apache.lucene.search.Query)new TermQuery(new Term(field, (String)value1)), BooleanClause.Occur.SHOULD));
            return filterApisQuery.build();
        }
        return null;
    }

    private boolean hasExplicitFilter(String query) {
        if (query != null) {
            return Arrays.asList(AUTHORIZED_EXPLICIT_FILTER).stream().anyMatch(field -> query.contains(field + ":"));
        }
        return false;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return source.isAssignableFrom(ApiEntity.class);
    }

    @Override
    protected String getReference(Document document) {
        String type = document.get("type");
        if (FIELD_API_TYPE_VALUE.equals(type)) {
            return document.get("id");
        }
        if (FIELD_PAGE_TYPE_VALUE.equals(type)) {
            return document.get("reference_id");
        }
        return null;
    }
}

