/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Component;

@Component
public class PageDocumentTransformer
implements DocumentTransformer<PageEntity> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    public static final String FIELD_TYPE_VALUE = "page";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NAME_LOWERCASE = "name_lowercase";
    public static final String FIELD_NAME_SPLIT = "name_split";
    public static final String FIELD_CONTENT = "content";

    @Override
    public Document transform(PageEntity page) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("reference_type", page.getReferenceType().toLowerCase(), Field.Store.NO));
        doc.add((IndexableField)new StringField("reference_id", page.getReferenceId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_ID, page.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        if (page.getName() != null) {
            doc.add((IndexableField)new StringField(FIELD_NAME, page.getName(), Field.Store.NO));
            doc.add((IndexableField)new StringField(FIELD_NAME_LOWERCASE, page.getName().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_NAME_SPLIT, page.getName(), Field.Store.NO));
        }
        if (page.getContent() != null) {
            doc.add((IndexableField)new TextField(FIELD_CONTENT, page.getContent(), Field.Store.NO));
        }
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return PageEntity.class.isAssignableFrom(source);
    }
}

