/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.NotificationTemplateRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.NotificationTemplate;
import io.gravitee.repository.management.model.NotificationTemplateReferenceType;
import io.gravitee.repository.management.model.NotificationTemplateType;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.notification.NotificationTemplateEntity;
import io.gravitee.rest.api.model.notification.NotificationTemplateEvent;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.NotificationTemplateNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TemplateProcessingException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ActionHook;
import io.gravitee.rest.api.service.notification.AlertHook;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.notification.PortalHook;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.yaml.snakeyaml.Yaml;

@Component
public class NotificationTemplateServiceImpl
extends AbstractService
implements NotificationTemplateService,
InitializingBean {
    private static final String HTML_TEMPLATE_EXTENSION = "html";
    public static final String TEMPLATES_TO_INCLUDE_SCOPE = "TEMPLATES_TO_INCLUDE";
    private final Logger LOGGER = LoggerFactory.getLogger(NotificationTemplateServiceImpl.class);
    @Value(value="${templates.path:${gravitee.home}/templates}")
    private String templatesPath;
    @Autowired
    private NotificationTemplateRepository notificationTemplateRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private EventManager eventManager;
    private Map<String, Configuration> freemarkerConfigurationByOrg = new HashMap<String, Configuration>();
    private Map<String, StringTemplateLoader> stringTemplateLoaderMapByOrg = new HashMap<String, StringTemplateLoader>();
    private Map<String, NotificationTemplateEntity> fromFilesNotificationTemplateEntities = new HashMap<String, NotificationTemplateEntity>();

    public void afterPropertiesSet() throws Exception {
        ArrayList allHooks = new ArrayList();
        Collections.addAll(allHooks, PortalHook.values());
        Collections.addAll(allHooks, ApiHook.values());
        Collections.addAll(allHooks, ApplicationHook.values());
        Collections.addAll(allHooks, ActionHook.values());
        Collections.addAll(allHooks, AlertHook.values());
        this.fromFilesNotificationTemplateEntities = allHooks.stream().map(this::loadNotificationTemplatesFromHook).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(NotificationTemplateEntity::getTemplateName, Function.identity()));
        this.fromFilesNotificationTemplateEntities.putAll(this.addExtraHtmlTemplate());
    }

    private Map<String, NotificationTemplateEntity> addExtraHtmlTemplate() {
        try {
            return Files.list(new File(this.templatesPath).toPath()).filter(path -> path.getFileName().toString().endsWith(HTML_TEMPLATE_EXTENSION)).filter(path -> EmailNotificationBuilder.EmailTemplate.fromHtmlTemplateName(path.getFileName().toString()) == null).map(path -> this.loadEmailNotificationTemplateFromFile((Path)path)).filter(Objects::nonNull).collect(Collectors.toMap(NotificationTemplateEntity::getTemplateName, Function.identity()));
        }
        catch (IOException e) {
            this.LOGGER.warn("Problem while getting freemarker templates from files", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public String resolveInlineTemplateWithParam(String name, String inlineTemplate, Object params, boolean ignoreTplException) {
        return this.resolveInlineTemplateWithParam(name, new StringReader(inlineTemplate), params, ignoreTplException);
    }

    @Override
    public String resolveInlineTemplateWithParam(String name, Reader inlineTemplateReader, Object params, boolean ignoreTplException) {
        Configuration orgFreemarkerConfiguration = this.getCurrentOrgConfiguration();
        try {
            Template template = new Template(name, inlineTemplateReader, orgFreemarkerConfiguration);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)params);
        }
        catch (IOException e) {
            this.LOGGER.warn("Error while creating template from reader:\n{}", (Object)e.getMessage());
            return "";
        }
        catch (TemplateException e) {
            if (ignoreTplException) {
                this.LOGGER.warn("Error while processing the inline reader:\n{}", (Object)e.getMessage());
                return "";
            }
            throw new TemplateProcessingException(e);
        }
    }

    @Override
    public String resolveTemplateWithParam(String templateName, Object params) {
        Configuration orgFreemarkerConfiguration = this.getCurrentOrgConfiguration();
        try {
            Template template = orgFreemarkerConfiguration.getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)params);
        }
        catch (IOException e) {
            this.LOGGER.warn("Error while getting template {}:\n{}", (Object)templateName, (Object)e.getMessage());
            return "";
        }
        catch (TemplateException e) {
            this.LOGGER.warn("Error while processing the template {}:\n{}", (Object)templateName, (Object)e.getMessage());
            return "";
        }
    }

    @NotNull
    private Configuration getCurrentOrgConfiguration() {
        String currentOrganization = GraviteeContext.getCurrentOrganization();
        Configuration orgFreemarkerConfiguration = this.freemarkerConfigurationByOrg.get(currentOrganization);
        if (orgFreemarkerConfiguration == null) {
            orgFreemarkerConfiguration = this.initCurrentOrgFreemarkerConfiguration(currentOrganization);
            this.freemarkerConfigurationByOrg.put(currentOrganization, orgFreemarkerConfiguration);
        }
        return orgFreemarkerConfiguration;
    }

    private Configuration initCurrentOrgFreemarkerConfiguration(String currentOrganization) {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        MultiTemplateLoader multiLoader = this.createMultiTemplateLoaderForOrganization(currentOrganization);
        configuration.setTemplateLoader((TemplateLoader)multiLoader);
        return configuration;
    }

    @NotNull
    private MultiTemplateLoader createMultiTemplateLoaderForOrganization(String currentOrganization) {
        ArrayList<StringTemplateLoader> loaders = new ArrayList<StringTemplateLoader>();
        StringTemplateLoader orgCustomizedTemplatesLoader = new StringTemplateLoader();
        this.findAllInDatabase(currentOrganization, NotificationTemplateReferenceType.ORGANIZATION).forEach(template -> {
            if (template.isEnabled().booleanValue()) {
                if (template.getTitle() != null && !template.getTitle().isEmpty()) {
                    orgCustomizedTemplatesLoader.putTemplate(template.getTitleTemplateName(), template.getTitle());
                }
                orgCustomizedTemplatesLoader.putTemplate(template.getContentTemplateName(), template.getContent());
            }
        });
        loaders.add(orgCustomizedTemplatesLoader);
        this.stringTemplateLoaderMapByOrg.put(currentOrganization, orgCustomizedTemplatesLoader);
        StringTemplateLoader fileNotificationTemplatesLoader = new StringTemplateLoader();
        this.fromFilesNotificationTemplateEntities.values().stream().forEach(template -> {
            if (template.getTitle() != null && !template.getTitle().isEmpty()) {
                fileNotificationTemplatesLoader.putTemplate(template.getTitleTemplateName(), template.getTitle());
            }
            fileNotificationTemplatesLoader.putTemplate(template.getContentTemplateName(), template.getContent());
        });
        loaders.add(fileNotificationTemplatesLoader);
        MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()]));
        multiTemplateLoader.setSticky(false);
        return multiTemplateLoader;
    }

    @Override
    public Set<NotificationTemplateEntity> findAll() {
        Set<NotificationTemplateEntity> allFromDatabase = this.findAllInDatabase(GraviteeContext.getCurrentOrganization(), NotificationTemplateReferenceType.ORGANIZATION);
        HashSet<NotificationTemplateEntity> all = new HashSet<NotificationTemplateEntity>();
        all.addAll(allFromDatabase);
        all.addAll(this.fromFilesNotificationTemplateEntities.values());
        return all;
    }

    private Set<NotificationTemplateEntity> findAllInDatabase(String referenceId, NotificationTemplateReferenceType referenceType) {
        try {
            return this.notificationTemplateRepository.findAllByReferenceIdAndReferenceType(referenceId, referenceType).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve notificationTemplates", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve notificationTemplates", ex);
        }
    }

    private List<NotificationTemplateEntity> loadNotificationTemplatesFromHook(Hook hook) {
        NotificationTemplateEntity emailNotificationTemplateEntity;
        NotificationTemplateEntity portalNotificationTemplateEntity;
        ArrayList<NotificationTemplateEntity> result = new ArrayList<NotificationTemplateEntity>();
        if (hook.getScope().hasPortalNotification() && (portalNotificationTemplateEntity = this.loadPortalNotificationTemplateFromHook(hook)) != null) {
            result.add(portalNotificationTemplateEntity);
        }
        if ((emailNotificationTemplateEntity = this.loadEmailNotificationTemplateFromHook(hook)) != null) {
            result.add(emailNotificationTemplateEntity);
        }
        return result;
    }

    private NotificationTemplateEntity loadPortalNotificationTemplateFromHook(Hook hook) {
        String RELATIVE_TPL_PATH = "notifications/portal/";
        String templateName = hook.getTemplate() + "." + io.gravitee.rest.api.model.notification.NotificationTemplateType.PORTAL.name();
        File portalTemplateFile = new File(this.templatesPath + "/notifications/portal/" + hook.getTemplate() + ".yml");
        try {
            Yaml yaml = new Yaml();
            Map load = (Map)yaml.load((InputStream)new FileInputStream(portalTemplateFile));
            return new NotificationTemplateEntity(hook.name(), hook.getScope().name(), templateName, hook.getLabel(), hook.getDescription(), (String)load.get("title"), (String)load.get("message"), io.gravitee.rest.api.model.notification.NotificationTemplateType.PORTAL);
        }
        catch (IOException e) {
            this.LOGGER.warn("Problem while getting freemarker template {} from file : {}", (Object)hook.getTemplate(), (Object)e.getMessage());
            return null;
        }
    }

    private NotificationTemplateEntity loadEmailNotificationTemplateFromHook(Hook hook) {
        String templateName = hook.getTemplate() + "." + io.gravitee.rest.api.model.notification.NotificationTemplateType.EMAIL.name();
        EmailNotificationBuilder.EmailTemplate emailTemplate = EmailNotificationBuilder.EmailTemplate.fromHook(hook);
        if (emailTemplate != null) {
            File emailTemplateFile = new File(this.templatesPath + "/" + emailTemplate.getHtmlTemplate());
            try {
                String title = emailTemplate == null ? "unused title" : emailTemplate.getSubject();
                String content = new String(Files.readAllBytes(emailTemplateFile.toPath()));
                return new NotificationTemplateEntity(hook.name(), hook.getScope().name(), templateName, hook.getLabel(), hook.getDescription(), title, content, io.gravitee.rest.api.model.notification.NotificationTemplateType.EMAIL);
            }
            catch (IOException e) {
                this.LOGGER.warn("Problem while getting freemarker template {} from file : {}", (Object)hook.getTemplate(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private NotificationTemplateEntity loadEmailNotificationTemplateFromFile(Path fileTemplateName) {
        String templateName = fileTemplateName.getFileName().toString();
        try {
            File templateFile = fileTemplateName.toFile();
            String content = new String(Files.readAllBytes(templateFile.toPath()));
            return new NotificationTemplateEntity("", TEMPLATES_TO_INCLUDE_SCOPE, templateName, templateName, null, null, content, io.gravitee.rest.api.model.notification.NotificationTemplateType.EMAIL);
        }
        catch (IOException e) {
            this.LOGGER.warn("Problem while getting freemarker template {} from file : {}", (Object)templateName, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Set<NotificationTemplateEntity> findByType(io.gravitee.rest.api.model.notification.NotificationTemplateType type) {
        try {
            return this.notificationTemplateRepository.findByTypeAndReferenceIdAndReferenceType(NotificationTemplateType.valueOf((String)type.name()), GraviteeContext.getCurrentOrganization(), NotificationTemplateReferenceType.ORGANIZATION).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve notificationTemplates by type", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve notificationTemplates by type", ex);
        }
    }

    @Override
    public Set<NotificationTemplateEntity> findByHookAndScope(String hook, String scope) {
        return this.findAll().stream().filter(notificationTemplateEntity -> notificationTemplateEntity.getHook().equalsIgnoreCase(hook) && notificationTemplateEntity.getScope().equalsIgnoreCase(scope)).collect(Collectors.toSet());
    }

    @Override
    public NotificationTemplateEntity create(NotificationTemplateEntity newNotificationTemplate) {
        try {
            this.LOGGER.debug("Create notificationTemplate {}", (Object)newNotificationTemplate);
            newNotificationTemplate.setId(UuidString.generateRandom());
            if (newNotificationTemplate.getCreatedAt() == null) {
                newNotificationTemplate.setCreatedAt(new Date());
            }
            NotificationTemplate createdNotificationTemplate = this.notificationTemplateRepository.create(this.convert(newNotificationTemplate));
            this.createAuditLog((Audit.AuditEvent)NotificationTemplate.AuditEvent.NOTIFICATION_TEMPLATE_CREATED, newNotificationTemplate.getCreatedAt(), null, createdNotificationTemplate);
            NotificationTemplateEntity createdNotificationTemplateEntity = this.convert(createdNotificationTemplate);
            this.updateFreemarkerCache(createdNotificationTemplateEntity);
            return createdNotificationTemplateEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create or update notificationTemplate {}", (Object)newNotificationTemplate, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create or update " + newNotificationTemplate, ex);
        }
    }

    @Override
    public NotificationTemplateEntity update(NotificationTemplateEntity updatingNotificationTemplate) {
        try {
            this.LOGGER.debug("Update notificationTemplate {}", (Object)updatingNotificationTemplate);
            if (updatingNotificationTemplate.getUpdatedAt() == null) {
                updatingNotificationTemplate.setUpdatedAt(new Date());
            }
            Optional optNotificationTemplate = this.notificationTemplateRepository.findById(updatingNotificationTemplate.getId());
            NotificationTemplate notificationTemplateToUpdate = (NotificationTemplate)optNotificationTemplate.orElseThrow(() -> new NotificationTemplateNotFoundException(updatingNotificationTemplate.getId()));
            notificationTemplateToUpdate.setTitle(updatingNotificationTemplate.getTitle());
            notificationTemplateToUpdate.setContent(updatingNotificationTemplate.getContent());
            notificationTemplateToUpdate.setEnabled(updatingNotificationTemplate.isEnabled().booleanValue());
            NotificationTemplate updatedNotificationTemplate = this.notificationTemplateRepository.update(notificationTemplateToUpdate);
            this.createAuditLog((Audit.AuditEvent)NotificationTemplate.AuditEvent.NOTIFICATION_TEMPLATE_UPDATED, updatingNotificationTemplate.getUpdatedAt(), (NotificationTemplate)optNotificationTemplate.get(), updatedNotificationTemplate);
            NotificationTemplateEntity updatedNotificationTemplateEntity = this.convert(updatedNotificationTemplate);
            this.updateFreemarkerCache(updatedNotificationTemplateEntity);
            return updatedNotificationTemplateEntity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create or update notificationTemplate {}", (Object)updatingNotificationTemplate, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create or update " + updatingNotificationTemplate, ex);
        }
    }

    private void updateFreemarkerCache(NotificationTemplateEntity notificationTemplate) {
        StringTemplateLoader orgCustomizedTemplatesLoader = this.stringTemplateLoaderMapByOrg.get(GraviteeContext.getCurrentOrganization());
        if (orgCustomizedTemplatesLoader == null) {
            Configuration orgFreemarkerConfiguration = this.initCurrentOrgFreemarkerConfiguration(GraviteeContext.getCurrentOrganization());
            this.freemarkerConfigurationByOrg.put(GraviteeContext.getCurrentOrganization(), orgFreemarkerConfiguration);
            orgCustomizedTemplatesLoader = this.stringTemplateLoaderMapByOrg.get(GraviteeContext.getCurrentOrganization());
        }
        if (notificationTemplate.isEnabled().booleanValue()) {
            if (notificationTemplate.getTitle() != null && !notificationTemplate.getTitle().isEmpty()) {
                orgCustomizedTemplatesLoader.putTemplate(notificationTemplate.getTitleTemplateName(), notificationTemplate.getTitle());
            }
            orgCustomizedTemplatesLoader.putTemplate(notificationTemplate.getContentTemplateName(), notificationTemplate.getContent());
        } else {
            orgCustomizedTemplatesLoader.removeTemplate(notificationTemplate.getTitleTemplateName());
            orgCustomizedTemplatesLoader.removeTemplate(notificationTemplate.getContentTemplateName());
        }
        try {
            this.freemarkerConfigurationByOrg.get(GraviteeContext.getCurrentOrganization()).removeTemplateFromCache(notificationTemplate.getTitleTemplateName());
            this.freemarkerConfigurationByOrg.get(GraviteeContext.getCurrentOrganization()).removeTemplateFromCache(notificationTemplate.getName());
        }
        catch (IOException ex) {
            this.LOGGER.error("An error occurs while trying to update freemarker cache with this template {}", (Object)notificationTemplate, (Object)ex);
        }
        if (HookScope.TEMPLATES_FOR_ALERT.name().equals(notificationTemplate.getScope())) {
            this.eventManager.publishEvent((Enum)ApplicationAlertEventType.NOTIFICATION_TEMPLATE_UPDATE, (Object)new NotificationTemplateEvent(GraviteeContext.getCurrentOrganization(), notificationTemplate));
        }
    }

    @Override
    public NotificationTemplateEntity findById(String id) {
        try {
            this.LOGGER.debug("Find notificationTemplate by ID: {}", (Object)id);
            Optional notificationTemplate = this.notificationTemplateRepository.findById(id);
            if (notificationTemplate.isPresent()) {
                return this.convert((NotificationTemplate)notificationTemplate.get());
            }
            throw new NotificationTemplateNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a notificationTemplate using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a notificationTemplate using its ID " + id, ex);
        }
    }

    private void createAuditLog(Audit.AuditEvent event, Date createdAt, NotificationTemplate oldValue, NotificationTemplate newValue) {
        String notificationTemplateName = oldValue != null ? oldValue.getName() : newValue.getName();
        this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.NOTIFICATION_TEMPLATE, notificationTemplateName), event, createdAt, oldValue, newValue);
    }

    private NotificationTemplate convert(NotificationTemplateEntity notificationTemplateEntity) {
        NotificationTemplate notificationTemplate = new NotificationTemplate();
        notificationTemplate.setId(notificationTemplateEntity.getId());
        notificationTemplate.setHook(notificationTemplateEntity.getHook());
        notificationTemplate.setScope(notificationTemplateEntity.getScope());
        notificationTemplate.setReferenceId(GraviteeContext.getCurrentOrganization());
        notificationTemplate.setReferenceType(NotificationTemplateReferenceType.ORGANIZATION);
        notificationTemplate.setName(notificationTemplateEntity.getName());
        notificationTemplate.setDescription(notificationTemplateEntity.getDescription());
        notificationTemplate.setTitle(notificationTemplateEntity.getTitle());
        notificationTemplate.setContent(notificationTemplateEntity.getContent());
        notificationTemplate.setType(NotificationTemplateType.valueOf((String)notificationTemplateEntity.getType().name()));
        notificationTemplate.setCreatedAt(notificationTemplateEntity.getCreatedAt());
        notificationTemplate.setUpdatedAt(notificationTemplateEntity.getUpdatedAt());
        notificationTemplate.setEnabled(notificationTemplateEntity.isEnabled().booleanValue());
        return notificationTemplate;
    }

    private NotificationTemplateEntity convert(NotificationTemplate notificationTemplate) {
        NotificationTemplateEntity notificationTemplateEntity = new NotificationTemplateEntity();
        notificationTemplateEntity.setId(notificationTemplate.getId());
        notificationTemplateEntity.setHook(notificationTemplate.getHook());
        notificationTemplateEntity.setScope(notificationTemplate.getScope());
        notificationTemplateEntity.setName(notificationTemplate.getName());
        notificationTemplateEntity.setDescription(notificationTemplate.getDescription());
        notificationTemplateEntity.setTitle(notificationTemplate.getTitle());
        notificationTemplateEntity.setContent(notificationTemplate.getContent());
        notificationTemplateEntity.setType(io.gravitee.rest.api.model.notification.NotificationTemplateType.valueOf((String)notificationTemplate.getType().name()));
        notificationTemplateEntity.setCreatedAt(notificationTemplate.getCreatedAt());
        notificationTemplateEntity.setUpdatedAt(notificationTemplate.getUpdatedAt());
        notificationTemplateEntity.setEnabled(Boolean.valueOf(notificationTemplate.isEnabled()));
        if (TEMPLATES_TO_INCLUDE_SCOPE.equalsIgnoreCase(notificationTemplate.getScope())) {
            notificationTemplateEntity.setTemplateName(notificationTemplate.getName());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(notificationTemplate.getScope());
            sb.append(".");
            sb.append(notificationTemplate.getHook());
            sb.append(".");
            sb.append(notificationTemplate.getType());
            notificationTemplateEntity.setTemplateName(sb.toString().toUpperCase());
        }
        return notificationTemplateEntity;
    }
}

