/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.EndpointType;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.jackson.ser.api.PlanEntityBefore_3_00;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Api1_25VersionSerializer
extends ApiSerializer {
    public Api1_25VersionSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, final JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List filteredFieldsList;
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        if (apiEntity.getPathMappings() != null) {
            jsonGenerator.writeArrayFieldStart("path_mappings");
            apiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    jsonGenerator.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProxy() != null) {
            jsonGenerator.writeObjectFieldStart("proxy");
            Iterator<Object> virtualHostIterator = apiEntity.getProxy().getVirtualHosts().iterator();
            if (virtualHostIterator.hasNext()) {
                jsonGenerator.writeObjectField("context_path", (Object)((VirtualHost)virtualHostIterator.next()).getPath());
            }
            jsonGenerator.writeObjectField("strip_context_path", (Object)apiEntity.getProxy().isStripContextPath());
            if (apiEntity.getProxy().getLogging() != null) {
                jsonGenerator.writeObjectField("logging", (Object)apiEntity.getProxy().getLogging());
            }
            jsonGenerator.writeArrayFieldStart("groups");
            apiEntity.getProxy().getGroups().forEach(new Consumer<EndpointGroup>(){

                @Override
                public void accept(EndpointGroup endpointGroup) {
                    try {
                        if (endpointGroup.getEndpoints() != null) {
                            endpointGroup.setEndpoints(endpointGroup.getEndpoints().stream().filter(endpoint -> endpoint.getType() == EndpointType.HTTP).collect(Collectors.toSet()));
                        }
                        jsonGenerator.writeObject((Object)endpointGroup);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            jsonGenerator.writeEndArray();
            if (apiEntity.getProxy().getFailover() != null) {
                jsonGenerator.writeObjectField("failover", (Object)apiEntity.getProxy().getFailover());
            }
            if (apiEntity.getProxy().getCors() != null) {
                jsonGenerator.writeObjectField("cors", (Object)apiEntity.getProxy().getCors());
            }
            jsonGenerator.writeEndObject();
        }
        if (apiEntity.getResponseTemplates() != null) {
            jsonGenerator.writeObjectFieldStart("response_templates");
            for (Map.Entry entry : apiEntity.getResponseTemplates().entrySet()) {
                jsonGenerator.writeObjectFieldStart((String)entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    jsonGenerator.writeObjectField((String)entry2.getKey(), entry2.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        if (!(filteredFieldsList = (List)apiEntity.getMetadata().get(METADATA_FILTERED_FIELDS_LIST)).contains("members")) {
            Set<MemberEntity> set = ((MembershipService)this.applicationContext.getBean(MembershipService.class)).getMembersByReference(MembershipReferenceType.API, apiEntity.getId());
            ArrayList members = new ArrayList(set == null ? 0 : set.size());
            if (set != null) {
                set.forEach(m -> {
                    UserEntity userEntity = ((UserService)this.applicationContext.getBean(UserService.class)).findById(m.getId());
                    if (userEntity != null) {
                        ApiSerializer.Member member = new ApiSerializer.Member(this);
                        member.setRole(((RoleEntity)m.getRoles().get(0)).getName());
                        member.setSource(userEntity.getSource());
                        member.setSourceId(userEntity.getSourceId());
                        members.add(member);
                    }
                });
            }
            jsonGenerator.writeObjectField("members", members);
        }
        if (!filteredFieldsList.contains("plans")) {
            Set<PlanEntity> set = ((PlanService)this.applicationContext.getBean(PlanService.class)).findByApi(apiEntity.getId());
            Set plansToAdd = set == null ? Collections.emptySet() : set.stream().filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus())).map(PlanEntityBefore_3_00::fromNewPlanEntity).collect(Collectors.toSet());
            jsonGenerator.writeObjectField("plans", plansToAdd);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.V_1_25;
    }
}

