/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.configuration.identity.GroupMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderType;
import io.gravitee.rest.api.model.configuration.identity.NewIdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.RoleMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.UpdateIdentityProviderEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.exceptions.OrganizationNotFoundException;
import io.gravitee.rest.api.service.impl.configuration.identity.IdentityProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class IdentityProviderUpgrader
implements Upgrader,
Ordered {
    private static final String description = "Configuration provided by the system. Every modifications will be overridden at the next startup.";
    private final Logger logger = LoggerFactory.getLogger(IdentityProviderUpgrader.class);
    private List<String> notStorableIDPs = Arrays.asList("gravitee", "ldap", "memory");
    private List<String> idpTypeNames = Arrays.stream(IdentityProviderType.values()).map(Enum::name).collect(Collectors.toList());
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private GroupService groupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private IdentityProviderService identityProviderService;
    @Autowired
    private IdentityProviderActivationService identityProviderActivationService;

    @Override
    public boolean upgrade() {
        boolean found = true;
        int idx = 0;
        while (found) {
            String type = this.environment.getProperty("security.providers[" + idx + "].type");
            boolean bl = found = type != null;
            if (found && !this.notStorableIDPs.contains(type)) {
                if (this.idpTypeNames.contains(type.toUpperCase())) {
                    this.logger.info("Upsert identity provider config [{}]", (Object)type);
                    String id = this.environment.getProperty("security.providers[" + idx + "].id");
                    if (id == null) {
                        id = type;
                    }
                    try {
                        this.identityProviderService.findById(id);
                    }
                    catch (IdentityProviderNotFoundException e) {
                        id = this.createIdp(id, IdentityProviderType.valueOf((String)type.toUpperCase()), idx);
                    }
                    this.updateIdp(id, idx);
                    this.updateIdpActivations(id, idx);
                } else {
                    this.logger.info("Unknown identity provider [{}]", (Object)type);
                }
            }
            ++idx;
        }
        return true;
    }

    private String createIdp(String id, IdentityProviderType type, int providerIndex) {
        NewIdentityProviderEntity idp = new NewIdentityProviderEntity();
        idp.setName(id);
        idp.setType(type);
        idp.setDescription(description);
        idp.setEnabled(true);
        idp.setConfiguration(this.getConfiguration(providerIndex));
        idp.setEmailRequired(Boolean.valueOf(idp.getConfiguration().getOrDefault("emailRequired", "false")).booleanValue());
        idp.setSyncMappings(Boolean.valueOf(idp.getConfiguration().getOrDefault("syncMappings", "false")).booleanValue());
        Map<String, String> userProfileMapping = this.getUserProfileMapping(providerIndex);
        if (!userProfileMapping.isEmpty()) {
            idp.setUserProfileMapping(userProfileMapping);
        }
        return this.identityProviderService.create(idp).getId();
    }

    private void updateIdpActivations(String id, int providerIndex) {
        this.identityProviderActivationService.deactivateIdpOnAllTargets(id);
        IdentityProviderActivationService.ActivationTarget[] targets = this.getActivationsTarget(providerIndex);
        if (targets.length > 0) {
            this.identityProviderActivationService.activateIdpOnTargets(id, targets);
        }
    }

    private IdentityProviderActivationService.ActivationTarget[] getActivationsTarget(int providerIndex) {
        List<String> targetStrings = this.getListOfString("security.providers[" + providerIndex + "].activations");
        ArrayList activationTargets = new ArrayList();
        targetStrings.forEach(target -> {
            String[] orgEnv = target.split(":");
            if (orgEnv.length == 1) {
                try {
                    this.organizationService.findById(orgEnv[0]);
                    activationTargets.add(new IdentityProviderActivationService.ActivationTarget(orgEnv[0], IdentityProviderActivationReferenceType.ORGANIZATION));
                }
                catch (OrganizationNotFoundException onfe) {
                    this.logger.warn("Organization {} does not exist", (Object)orgEnv[0]);
                }
            } else if (orgEnv.length == 2) {
                try {
                    this.organizationService.findById(orgEnv[0]);
                    EnvironmentEntity env = this.environmentService.findById(orgEnv[1]);
                    if (env.getOrganizationId().equals(orgEnv[0])) {
                        activationTargets.add(new IdentityProviderActivationService.ActivationTarget(orgEnv[1], IdentityProviderActivationReferenceType.ENVIRONMENT));
                    } else {
                        this.logger.warn("Environment {} does not exist in organization {}", (Object)orgEnv[1], (Object)orgEnv[0]);
                    }
                }
                catch (OrganizationNotFoundException onfe) {
                    this.logger.warn("Organization {} does not exist", (Object)orgEnv[0]);
                }
                catch (EnvironmentNotFoundException Enfe) {
                    this.logger.warn("Environment {} does not exist", (Object)orgEnv[1]);
                }
            }
        });
        return activationTargets.toArray(new IdentityProviderActivationService.ActivationTarget[activationTargets.size()]);
    }

    private void updateIdp(String id, int providerIndex) {
        List<RoleMappingEntity> roleMappings;
        List<GroupMappingEntity> groupMappings;
        UpdateIdentityProviderEntity idp = new UpdateIdentityProviderEntity();
        idp.setName(id);
        idp.setDescription(description);
        idp.setConfiguration(this.getConfiguration(providerIndex));
        idp.setEmailRequired(Boolean.valueOf(idp.getConfiguration().getOrDefault("emailRequired", "false")).booleanValue());
        idp.setEnabled(true);
        idp.setSyncMappings(Boolean.valueOf(idp.getConfiguration().getOrDefault("syncMappings", "false")).booleanValue());
        Map<String, String> userProfileMapping = this.getUserProfileMapping(providerIndex);
        if (!userProfileMapping.isEmpty()) {
            idp.setUserProfileMapping(userProfileMapping);
        }
        if (!(groupMappings = this.getGroupMappings(providerIndex)).isEmpty()) {
            idp.setGroupMappings(groupMappings);
        }
        if (!(roleMappings = this.getRoleMappings(providerIndex)).isEmpty()) {
            idp.setRoleMappings(roleMappings);
        }
        this.identityProviderService.update(id, idp);
    }

    private Map<String, Object> getConfiguration(int providerIndex) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        String prefix = "security.providers[" + providerIndex + "].";
        this.putIfNotNull(config, prefix, "clientId");
        this.putIfNotNull(config, prefix, "clientSecret");
        this.putIfNotNull(config, prefix, "color");
        this.putIfNotNull(config, prefix, "tokenEndpoint");
        this.putIfNotNull(config, prefix, "authorizeEndpoint");
        this.putIfNotNull(config, prefix, "tokenIntrospectionEndpoint");
        this.putIfNotNull(config, prefix, "userInfoEndpoint");
        this.putIfNotNull(config, prefix, "userLogoutEndpoint");
        this.putIfNotNull(config, prefix, "serverURL");
        this.putIfNotNull(config, prefix, "domain");
        this.putIfNotNull(config, prefix, "emailRequired");
        this.putIfNotNull(config, prefix, "syncMappings");
        List<String> scopes = this.getListOfString("security.providers[" + providerIndex + "].scopes");
        if (!scopes.isEmpty()) {
            config.put("scopes", scopes);
        }
        return config;
    }

    private List<String> getListOfString(String listName) {
        boolean found = true;
        int idx = 0;
        ArrayList<String> scopes = new ArrayList<String>();
        while (found) {
            String scope = this.environment.getProperty(listName + "[" + idx + "]");
            boolean bl = found = scope != null;
            if (found) {
                scopes.add(scope);
            }
            ++idx;
        }
        return scopes;
    }

    private Map<String, String> getUserProfileMapping(int providerIndex) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        String prefix = "security.providers[" + providerIndex + "].userMapping.";
        this.putIfNotNull(mapping, prefix, "id");
        this.putIfNotNull(mapping, prefix, "email");
        this.putIfNotNull(mapping, prefix, "lastname");
        this.putIfNotNull(mapping, prefix, "firstname");
        this.putIfNotNull(mapping, prefix, "picture");
        return mapping;
    }

    private List<GroupMappingEntity> getGroupMappings(int providerIndex) {
        boolean found = true;
        int idx = 0;
        ArrayList<GroupMappingEntity> mapping = new ArrayList<GroupMappingEntity>();
        while (found) {
            String condition = this.environment.getProperty("security.providers[" + providerIndex + "].groupMapping[" + idx + "].condition");
            boolean bl = found = condition != null;
            if (found) {
                GroupMappingEntity groupMappingEntity = new GroupMappingEntity();
                groupMappingEntity.setCondition(condition);
                List<String> groupNames = this.getListOfString("security.providers[" + providerIndex + "].groupMapping[" + idx + "].groups");
                if (!groupNames.isEmpty()) {
                    ArrayList groups = new ArrayList();
                    groupNames.forEach(groupName -> {
                        List<GroupEntity> groupsFound = this.groupService.findByName((String)groupName);
                        if (groupsFound != null && groupsFound.size() == 1) {
                            groups.add(groupsFound.get(0).getId());
                        }
                    });
                    groupMappingEntity.setGroups(groups);
                }
                mapping.add(groupMappingEntity);
            }
            ++idx;
        }
        return mapping;
    }

    private List<RoleMappingEntity> getRoleMappings(int providerIndex) {
        boolean found = true;
        int idx = 0;
        ArrayList<RoleMappingEntity> mapping = new ArrayList<RoleMappingEntity>();
        while (found) {
            String condition = this.environment.getProperty("security.providers[" + providerIndex + "].roleMapping[" + idx + "].condition");
            boolean bl = found = condition != null;
            if (found) {
                List<String> roles = this.getListOfString("security.providers[" + providerIndex + "].roleMapping[" + idx + "].roles");
                RoleMappingEntity roleMappingEntity = this.identityProviderService.getRoleMappings(condition, roles);
                mapping.add(roleMappingEntity);
            }
            ++idx;
        }
        return mapping;
    }

    private void putIfNotNull(Map config, String prefix, String key) {
        String value = this.environment.getProperty(prefix + key);
        if (value != null) {
            config.put(key, value);
        }
    }

    @Override
    public int getOrder() {
        return 350;
    }
}

