/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.validator.PolicyHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class APIV1toAPIV2Converter {
    private static final Set<HttpMethod> HTTP_METHODS = Collections.unmodifiableSet(new HashSet<HttpMethod>(Arrays.asList(HttpMethod.CONNECT, HttpMethod.DELETE, HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.PATCH, HttpMethod.POST, HttpMethod.PUT, HttpMethod.TRACE)));

    public ApiEntity migrateToV2(ApiEntity apiEntity, Set<PolicyEntity> policies, Set<PlanEntity> plans) {
        apiEntity.setGraviteeDefinitionVersion(DefinitionVersion.V2.getLabel());
        apiEntity.setFlowMode(FlowMode.BEST_MATCH);
        apiEntity.setFlows(this.migratePathsToFlows(this.reversePathsOrder(apiEntity.getPaths()), policies));
        apiEntity.setPlans(this.migratePlans(plans, policies));
        apiEntity.setPaths(new HashMap());
        return apiEntity;
    }

    private List<Flow> migratePathsToFlows(Map<String, List<Rule>> paths, Set<PolicyEntity> policies) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        if (!CollectionUtils.isEmpty(paths)) {
            paths.forEach((pathKey, pathValue) -> {
                boolean oneFlowPerPathMode;
                boolean bl = oneFlowPerPathMode = pathValue.stream().map(rule -> {
                    HashSet methods = new HashSet(rule.getMethods());
                    methods.retainAll(HTTP_METHODS);
                    return methods;
                }).distinct().count() == 1L;
                if (oneFlowPerPathMode) {
                    Flow flow = this.createFlow((String)pathKey, ((Rule)pathValue.get(0)).getMethods());
                    pathValue.forEach(rule -> this.configurePolicies(policies, (Rule)rule, flow));
                    Collections.reverse(flow.getPost());
                    flows.add(flow);
                } else {
                    pathValue.forEach(rule -> {
                        Flow flow = this.createFlow((String)pathKey, rule.getMethods());
                        this.configurePolicies(policies, (Rule)rule, flow);
                        Collections.reverse(flow.getPost());
                        flows.add(flow);
                    });
                }
            });
        }
        return flows;
    }

    private List<Plan> migratePlans(Set<PlanEntity> plans, Set<PolicyEntity> policies) {
        return plans.stream().filter(planEntity -> !PlanStatus.CLOSED.equals((Object)planEntity.getStatus())).map(planEntity -> {
            Plan plan = new Plan();
            plan.setId(planEntity.getId());
            plan.setApi(planEntity.getApi());
            plan.setName(planEntity.getName());
            plan.setSecurity(planEntity.getSecurity().name());
            plan.setSecurityDefinition(planEntity.getSecurityDefinition());
            plan.setStatus(planEntity.getStatus().name());
            plan.setFlows(this.migratePathsToFlows(planEntity.getPaths(), policies));
            if (planEntity.getTags() != null) {
                plan.setTags(new HashSet(planEntity.getTags()));
            }
            return plan;
        }).collect(Collectors.toList());
    }

    private void configurePolicies(Set<PolicyEntity> policies, Rule rule, Flow flow) {
        policies.stream().filter(policy -> policy.getId().equals(rule.getPolicy().getName())).findFirst().ifPresent(policy -> {
            String rulePolicyConfiguration = rule.getPolicy().getConfiguration();
            String safeRulePolicyConfiguration = PolicyHelper.clearNullValues(rulePolicyConfiguration);
            if (policy.getDevelopment().getOnRequestMethod() != null && policy.getDevelopment().getOnResponseMethod() != null) {
                try {
                    JsonNode jsonRulePolicyConfiguration = JsonLoader.fromString((String)safeRulePolicyConfiguration);
                    JsonNode scope = jsonRulePolicyConfiguration.get("scope");
                    if (scope == null) return;
                    switch (scope.asText()) {
                        case "REQUEST": 
                        case "REQUEST_CONTENT": {
                            Step step = this.createStep(rule, (PolicyEntity)policy, safeRulePolicyConfiguration);
                            flow.getPre().add(step);
                            return;
                        }
                        case "RESPONSE": 
                        case "RESPONSE_CONTENT": {
                            Step step = this.createStep(rule, (PolicyEntity)policy, safeRulePolicyConfiguration);
                            flow.getPost().add(step);
                            return;
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    throw new InvalidDataException("Unable to validate policy configuration", e);
                }
            } else if (policy.getDevelopment().getOnRequestMethod() != null) {
                Step step = this.createStep(rule, (PolicyEntity)policy, safeRulePolicyConfiguration);
                flow.getPre().add(step);
                return;
            } else {
                if (policy.getDevelopment().getOnResponseMethod() == null) return;
                Step step = this.createStep(rule, (PolicyEntity)policy, safeRulePolicyConfiguration);
                flow.getPost().add(step);
            }
        });
    }

    @NotNull
    private Step createStep(Rule rule, PolicyEntity policy, String safeRulePolicyConfiguration) {
        Step step = new Step();
        step.setName(policy.getName());
        step.setEnabled(rule.isEnabled());
        step.setDescription(rule.getDescription() != null ? rule.getDescription() : policy.getDescription());
        step.setPolicy(policy.getId());
        step.setConfiguration(safeRulePolicyConfiguration);
        return step;
    }

    @NotNull
    private Flow createFlow(String path, Set<HttpMethod> methods) {
        Set<Object> flowMethods = methods.containsAll(HTTP_METHODS) ? Collections.emptySet() : methods;
        Flow flow = new Flow();
        flow.setName("");
        flow.setCondition("");
        flow.setEnabled(true);
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(path);
        pathOperator.setOperator(Operator.STARTS_WITH);
        flow.setPathOperator(pathOperator);
        flow.setMethods(flowMethods);
        return flow;
    }

    private NavigableMap<String, List<Rule>> reversePathsOrder(Map<String, List<Rule>> pathsMap) {
        TreeMap reversedPaths = new TreeMap(Collections.reverseOrder());
        reversedPaths.putAll(pathsMap);
        return reversedPaths.descendingMap();
    }
}

