/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.impl.upgrade.UpgradeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ApiLoggingConditionUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiLoggingConditionUpgrader.class);
    @Autowired
    private InstallationService installationService;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public boolean upgrade() {
        InstallationEntity installation = this.installationService.getOrInitialize();
        if (this.isStatus(installation, UpgradeStatus.SUCCESS)) {
            LOGGER.info("Skipping {} execution because it has already been successfully executed", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, UpgradeStatus.RUNNING)) {
            LOGGER.warn("Skipping {} execution because it is already running", (Object)this.getClass().getSimpleName());
            return false;
        }
        try {
            LOGGER.info("Starting {} execution with dry-run", (Object)this.getClass().getSimpleName());
            this.setExecutionStatus(installation, UpgradeStatus.RUNNING);
            this.fixApis();
            this.setExecutionStatus(installation, UpgradeStatus.SUCCESS);
        }
        catch (Throwable e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            this.setExecutionStatus(installation, UpgradeStatus.FAILURE);
            return false;
        }
        return true;
    }

    protected void fixApis() throws Exception {
        for (Api api : this.apiRepository.findAll()) {
            String condition;
            io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            if (apiDefinition.getProxy() == null || apiDefinition.getProxy().getLogging() == null || apiDefinition.getProxy().getLogging().getCondition() == null || !(condition = apiDefinition.getProxy().getLogging().getCondition().trim()).contains("#") || condition.startsWith("{") || condition.endsWith("}")) continue;
            this.fixLoggingCondition(api, apiDefinition, condition);
        }
    }

    protected void fixLoggingCondition(Api api, io.gravitee.definition.model.Api apiDefinition, String condition) throws Exception {
        apiDefinition.getProxy().getLogging().setCondition("{" + condition + "}");
        api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
        this.apiRepository.update((Object)api);
    }

    @Override
    public int getOrder() {
        return 550;
    }

    private void setExecutionStatus(InstallationEntity installation, UpgradeStatus status) {
        installation.getAdditionalInformation().put("API_LOGGING_CONDITION_UPGRADER_STATUS", status.toString());
        this.installationService.setAdditionalInformation(installation.getAdditionalInformation());
    }

    private boolean isStatus(InstallationEntity installation, UpgradeStatus status) {
        return status.name().equals(installation.getAdditionalInformation().get("API_LOGGING_CONDITION_UPGRADER_STATUS"));
    }
}

