/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNotificationRepository;
import io.gravitee.repository.management.model.PortalNotification;
import io.gravitee.rest.api.model.notification.NewPortalNotificationEntity;
import io.gravitee.rest.api.model.notification.PortalNotificationEntity;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.PortalNotificationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalNotificationServiceImpl
extends AbstractService
implements PortalNotificationService {
    private final Logger LOGGER = LoggerFactory.getLogger(PortalNotificationServiceImpl.class);
    @Autowired
    private PortalNotificationRepository portalNotificationRepository;
    @Autowired
    private NotificationTemplateService notificationTemplateService;

    @Override
    public List<PortalNotificationEntity> findByUser(String user) {
        try {
            return this.portalNotificationRepository.findByUser(user).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find notifications by user {}", (Object)user, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find notifications by username " + user, ex);
        }
    }

    @Override
    public PortalNotificationEntity findById(String notificationId) {
        try {
            Optional portalNotification = this.portalNotificationRepository.findById(notificationId);
            if (portalNotification.isPresent()) {
                return this.convert((PortalNotification)portalNotification.get());
            }
            throw new PortalNotificationNotFoundException(notificationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find notification with id {}", (Object)notificationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find notification with id " + notificationId, ex);
        }
    }

    @Override
    public void create(Hook hook, List<String> users, Object params) {
        try {
            String title = this.notificationTemplateService.resolveTemplateWithParam(hook.getTemplate() + ".PORTAL.TITLE", params);
            String content = this.notificationTemplateService.resolveTemplateWithParam(hook.getTemplate() + ".PORTAL", params);
            ArrayList<NewPortalNotificationEntity> notifications = new ArrayList<NewPortalNotificationEntity>(users.size());
            users.forEach(user -> {
                NewPortalNotificationEntity notification = new NewPortalNotificationEntity();
                notification.setUser(user);
                notification.setTitle(title);
                notification.setMessage(content);
                notifications.add(notification);
            });
            this.create(notifications);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while sending notification", (Throwable)ex);
            throw new TechnicalManagementException("Error while sending notification", ex);
        }
    }

    @Override
    public void deleteAll(String user) {
        try {
            this.portalNotificationRepository.deleteAll(user);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete all notifications for user  {}", (Object)user, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying delete all notifications for user " + user, ex);
        }
    }

    @Override
    public void delete(String notificationId) {
        try {
            this.portalNotificationRepository.delete((Object)notificationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete {}", (Object)notificationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying delete " + notificationId, ex);
        }
    }

    private void create(List<NewPortalNotificationEntity> notificationEntities) {
        Date now = new Date();
        List<PortalNotification> notifications = notificationEntities.stream().map(this::convert).collect(Collectors.toList());
        notifications.forEach(n -> {
            n.setId(UuidString.generateRandom());
            n.setCreatedAt(now);
        });
        try {
            this.portalNotificationRepository.create(notifications);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {}", notifications, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + notifications, ex);
        }
    }

    private PortalNotification convert(NewPortalNotificationEntity entity) {
        PortalNotification notification = new PortalNotification();
        notification.setTitle(entity.getTitle());
        notification.setMessage(entity.getMessage());
        notification.setUser(entity.getUser());
        return notification;
    }

    private PortalNotificationEntity convert(PortalNotification notification) {
        PortalNotificationEntity entity = new PortalNotificationEntity();
        entity.setId(notification.getId());
        entity.setTitle(notification.getTitle());
        entity.setMessage(notification.getMessage());
        entity.setCreatedAt(notification.getCreatedAt());
        return entity;
    }
}

