/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.spel;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.el.spel.context.SecuredMethodResolver;
import io.gravitee.rest.api.service.configuration.spel.SpelService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.stereotype.Component;

@Component
public class SpelServiceImpl
implements SpelService {
    private static final String GRAMMAR_PATH = "/spel/grammar.json";
    SecuredMethodResolver securedMethodResolver = new SecuredMethodResolver();
    private List<Class> supportedTypes = new ArrayList(){
        {
            this.add(MultiValueMap.class);
            this.add(HttpHeaders.class);
            this.add(Map.class);
            this.add(Boolean.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Math.class);
            this.add(Object.class);
            this.add(List.class);
            this.add(Collection.class);
            this.add(Set.class);
            this.add(String.class);
            this.add(String[].class);
        }
    };

    @Override
    public JSONObject getGrammar() {
        try {
            JSONParser parser = new JSONParser(4032);
            InputStream resourceAsStream = this.getClass().getResourceAsStream(GRAMMAR_PATH);
            JSONObject parse = (JSONObject)parser.parse(resourceAsStream);
            Map<String, Object> types = this.buildTypes();
            parse.appendField("_types", types);
            return parse;
        }
        catch (UnsupportedEncodingException | ParseException throwable) {
            return null;
        }
    }

    private Map<String, Object> buildTypes() {
        HashMap<String, Object> types = new HashMap<String, Object>();
        this.supportedTypes.forEach(aClass -> types.put(aClass.getSimpleName(), this.buildType((Class<?>)aClass)));
        return types;
    }

    private Map<String, Object> buildType(Class<?> classz) {
        HashMap<String, Object> type = new HashMap<String, Object>();
        List methods = Arrays.stream(this.securedMethodResolver.getMethods(classz)).filter(f -> Modifier.isPublic(f.getModifiers())).map(method -> new MethodWrapper((Method)method)).collect(Collectors.toList());
        type.put("methods", methods);
        return type;
    }

    private static class ParameterWrapper
    extends HashMap {
        public ParameterWrapper(Parameter parameter) {
            this.put("name", parameter.getName());
            this.put("type", parameter.getType().getSimpleName());
        }
    }

    private static class MethodWrapper
    extends HashMap {
        public MethodWrapper(Method method) {
            this.put("name", method.getName());
            this.put("returnType", method.getReturnType().getSimpleName());
            List params = Arrays.stream(method.getParameters()).map(parameter -> new ParameterWrapper((Parameter)parameter)).collect(Collectors.toList());
            if (params.size() > 0) {
                this.put("params", params);
            }
        }
    }
}

