/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypesEntity;
import io.gravitee.rest.api.model.settings.Application;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import io.gravitee.rest.api.service.exceptions.ApplicationTypeNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationTypeServiceImpl
implements ApplicationTypeService {
    public static final String DEFINITION_PATH = "/applications/types.json";
    @Autowired
    private ConfigService configService;
    @Autowired
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public ApplicationTypesEntity getEnabledApplicationTypes() {
        JsonNode jsonTypes = this.getApplicationTypesConfiguration();
        return this.getFilteredApplicationTypes(jsonTypes);
    }

    @Override
    public ApplicationTypeEntity getApplicationType(String typeId) {
        return this.getApplicationTypesEntity().getData().stream().filter(typeEntity -> typeEntity.getId().equals(typeId.toLowerCase())).findFirst().orElseThrow(() -> new ApplicationTypeNotFoundException(typeId));
    }

    private ApplicationTypesEntity getApplicationTypesEntity() {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(DEFINITION_PATH);
            String rawJson = IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
            return (ApplicationTypesEntity)this.objectMapper.readValue(rawJson, ApplicationTypesEntity.class);
        }
        catch (IOException e) {
            throw new TechnicalManagementException("An error occurs while trying load application type definition", e);
        }
    }

    public ApplicationTypesEntity getFilteredApplicationTypes(JsonNode jsonTypes) {
        ApplicationTypesEntity applicationTypesEntity = this.getApplicationTypesEntity();
        List filteredData = applicationTypesEntity.getData().stream().filter(typeEntity -> jsonTypes.get(typeEntity.getId()).get("enabled").asBoolean(false)).collect(Collectors.toList());
        applicationTypesEntity.setData(filteredData);
        return applicationTypesEntity;
    }

    public JsonNode getApplicationTypesConfiguration() {
        Application applicationConfig = this.configService.getPortalSettings(GraviteeContext.getCurrentEnvironment()).getApplication();
        Application.ApplicationTypes types = applicationConfig.getTypes();
        if (!applicationConfig.getRegistration().getEnabled().booleanValue()) {
            types.getBrowserType().setEnabled(false);
            types.getBackendToBackendType().setEnabled(false);
            types.getNativeType().setEnabled(false);
            types.getWebType().setEnabled(false);
        }
        return (JsonNode)this.objectMapper.convertValue((Object)types, JsonNode.class);
    }
}

