/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.utils;

import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

public class AuthoritiesProvider {
    private final MembershipService membershipService;

    public AuthoritiesProvider(MembershipService membershipService) {
        this.membershipService = membershipService;
    }

    public Set<GrantedAuthority> retrieveAuthorities(String userId) {
        String currentEnvironment = GraviteeContext.getCurrentEnvironment();
        return this.retrieveAuthorities(userId, GraviteeContext.getCurrentOrganization(), currentEnvironment == null ? GraviteeContext.getDefaultEnvironment() : currentEnvironment);
    }

    public Set<GrantedAuthority> retrieveAuthorities(String userId, String organizationId, String environmentId) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        Set roles = this.membershipService.getRoles(MembershipReferenceType.PLATFORM, "DEFAULT", MembershipMemberType.USER, userId);
        roles.addAll(this.membershipService.getRoles(MembershipReferenceType.ORGANIZATION, organizationId, MembershipMemberType.USER, userId));
        roles.addAll(this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, environmentId, MembershipMemberType.USER, userId));
        if (!roles.isEmpty()) {
            authorities.addAll(AuthorityUtils.commaSeparatedStringToAuthorityList((String)roles.stream().map(r -> r.getScope().name() + ':' + r.getName()).collect(Collectors.joining(","))));
        }
        return authorities;
    }
}

