/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.authentication;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class GraviteeAuthenticationDetails
extends WebAuthenticationDetails {
    private final String remoteAddress;

    public GraviteeAuthenticationDetails(HttpServletRequest request) {
        super(request);
        String xfHeader = request.getHeader("X-Forwarded-For");
        this.remoteAddress = xfHeader == null ? request.getRemoteAddr() : xfHeader.split(",")[0];
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraviteeAuthenticationDetails) {
            GraviteeAuthenticationDetails rhs = (GraviteeAuthenticationDetails)((Object)obj);
            if (this.getRemoteAddress() == null && rhs.getRemoteAddress() != null) {
                return false;
            }
            if (this.getRemoteAddress() != null && rhs.getRemoteAddress() == null) {
                return false;
            }
            if (this.getRemoteAddress() != null && !this.getRemoteAddress().equals(rhs.getRemoteAddress())) {
                return false;
            }
            if (this.getSessionId() == null && rhs.getSessionId() != null) {
                return false;
            }
            if (this.getSessionId() != null && rhs.getSessionId() == null) {
                return false;
            }
            return this.getSessionId() == null || this.getSessionId().equals(rhs.getSessionId());
        }
        return false;
    }

    public int hashCode() {
        int code = 7654;
        if (this.getRemoteAddress() != null) {
            code *= this.getRemoteAddress().hashCode() % 7;
        }
        if (this.getSessionId() != null) {
            code *= this.getSessionId().hashCode() % 7;
        }
        return code;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

