/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.rest.filter;

import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class UriBuilderRequestFilter
implements ContainerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UriBuilderRequestFilter.class);
    private static final int NO_EXPLICIT_PORT = -1;
    private static final String LOCAL_PORTAL_PREFIX = "/portal";
    private static final String LOCAL_MANAGEMENT_PREFIX = "/management";
    public static final String X_ORIGINAL_FORWARDED_HOST = "X-Original-Forwarded-Host";
    @Inject
    private InstallationAccessQueryService installationAccessQueryService;

    public void filter(ContainerRequestContext ctx) throws IOException {
        UriBuilder baseBuilder = ctx.getUriInfo().getBaseUriBuilder();
        UriBuilder requestBuilder = ctx.getUriInfo().getRequestUriBuilder();
        ApiContext apiContext = this.detectApiContext(ctx);
        this.processProtocolHeader(ctx, baseBuilder, requestBuilder, apiContext);
        boolean usedOriginalHost = this.processHostHeader(ctx, baseBuilder, requestBuilder, apiContext);
        this.processPortHeader(ctx, baseBuilder, requestBuilder, usedOriginalHost);
        this.processPrefixHeader(ctx, baseBuilder, requestBuilder, apiContext);
    }

    private ApiContext detectApiContext(ContainerRequestContext ctx) {
        String absolutePath = ctx.getUriInfo().getAbsolutePath().getPath();
        if (absolutePath != null) {
            if (absolutePath.startsWith(LOCAL_PORTAL_PREFIX)) {
                return ApiContext.PORTAL;
            }
            if (absolutePath.startsWith(LOCAL_MANAGEMENT_PREFIX)) {
                return ApiContext.MANAGEMENT;
            }
        }
        return ApiContext.UNKNOWN;
    }

    private void processProtocolHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String protoHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Proto");
        if (protoHeaderValue != null) {
            baseBuilder.scheme(protoHeaderValue);
            requestBuilder.scheme(protoHeaderValue);
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        } else if (this.installationAccessQueryService != null && apiContext != ApiContext.UNKNOWN) {
            this.applyDefaultScheme(ctx, baseBuilder, requestBuilder, apiContext);
        }
    }

    private void applyDefaultScheme(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String apiUrl;
        switch (apiContext.ordinal()) {
            case 0: {
                String string = this.installationAccessQueryService.getPortalAPIUrl(GraviteeContext.getDefaultEnvironment());
                break;
            }
            case 1: {
                String string = this.installationAccessQueryService.getConsoleAPIUrl(GraviteeContext.getDefaultOrganization());
                break;
            }
            default: {
                String string = apiUrl = null;
            }
        }
        if (apiUrl != null) {
            try {
                URI uri = URI.create(apiUrl);
                String scheme = uri.getScheme();
                if (scheme != null) {
                    baseBuilder.scheme(scheme);
                    requestBuilder.scheme(scheme);
                    ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
                }
            }
            catch (Exception e) {
                log.warn("Unable to parse API URL: {}", (Object)apiUrl, (Object)e);
            }
        }
    }

    private boolean processHostHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String hostHeaderValue;
        String originalHostHeaderValue = this.getFirstHeaderValueOrNull(ctx, X_ORIGINAL_FORWARDED_HOST);
        boolean usedOriginalHost = originalHostHeaderValue != null;
        String string = hostHeaderValue = usedOriginalHost ? originalHostHeaderValue : this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Host");
        if (hostHeaderValue != null) {
            String[] hosts = hostHeaderValue.split(",");
            String effectiveHost = hosts[hosts.length - 1].trim();
            if (effectiveHost.contains(":")) {
                int lastColonIdx = effectiveHost.lastIndexOf(58);
                String host = effectiveHost.substring(0, lastColonIdx);
                int port = Integer.parseInt(effectiveHost.substring(lastColonIdx + 1));
                baseBuilder.host(host).port(port);
                requestBuilder.host(host).port(port);
            } else {
                baseBuilder.host(effectiveHost).port(-1);
                requestBuilder.host(effectiveHost).port(-1);
            }
            ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
        } else if (this.installationAccessQueryService != null && apiContext != ApiContext.UNKNOWN) {
            this.applyDefaultHost(ctx, baseBuilder, requestBuilder, apiContext);
        }
        return usedOriginalHost;
    }

    private void applyDefaultHost(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String apiUrl;
        switch (apiContext.ordinal()) {
            case 0: {
                String string = this.installationAccessQueryService.getPortalAPIUrl(GraviteeContext.getDefaultEnvironment());
                break;
            }
            case 1: {
                String string = this.installationAccessQueryService.getConsoleAPIUrl(GraviteeContext.getDefaultOrganization());
                break;
            }
            default: {
                String string = apiUrl = null;
            }
        }
        if (apiUrl != null) {
            try {
                URI uri = URI.create(apiUrl);
                String host = uri.getHost();
                int port = uri.getPort();
                if (host != null) {
                    baseBuilder.host(host);
                    requestBuilder.host(host);
                    if (port > 0) {
                        baseBuilder.port(port);
                        requestBuilder.port(port);
                    } else {
                        baseBuilder.port(-1);
                        requestBuilder.port(-1);
                    }
                    ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
                }
            }
            catch (Exception e) {
                log.warn("Unable to parse API URL: {}", (Object)apiUrl, (Object)e);
            }
        }
    }

    private void processPortHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, boolean usedOriginalHost) {
        String portHeaderValue;
        if (!usedOriginalHost && (portHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Port")) != null) {
            try {
                int port = Integer.parseInt(portHeaderValue);
                baseBuilder.port(port);
                requestBuilder.port(port);
                ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
            }
            catch (Exception e) {
                log.warn("Unable to parse port header value: {}", (Object)portHeaderValue, (Object)e);
            }
        }
    }

    private void processPrefixHeader(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String prefixHeaderValue = this.getFirstHeaderValueOrNull(ctx, "X-Forwarded-Prefix");
        if (prefixHeaderValue != null && !prefixHeaderValue.isEmpty()) {
            String currentPath = baseBuilder.build(new Object[0]).getPath();
            String currentRequestPath = requestBuilder.build(new Object[0]).getPath();
            this.updatePaths(ctx, baseBuilder, requestBuilder, this.joinPaths(prefixHeaderValue, currentPath), this.joinPaths(prefixHeaderValue, currentRequestPath));
        } else if (this.installationAccessQueryService != null && apiContext != ApiContext.UNKNOWN) {
            this.applyProxyPathReplacement(ctx, baseBuilder, requestBuilder, apiContext);
        }
    }

    private void applyProxyPathReplacement(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, ApiContext apiContext) {
        String proxyPath;
        String localPrefix = switch (apiContext.ordinal()) {
            case 0 -> LOCAL_PORTAL_PREFIX;
            case 1 -> LOCAL_MANAGEMENT_PREFIX;
            default -> null;
        };
        switch (apiContext.ordinal()) {
            case 0: {
                String string = this.installationAccessQueryService.getPortalApiPath();
                break;
            }
            case 1: {
                String string = this.installationAccessQueryService.getConsoleApiPath();
                break;
            }
            default: {
                String string = proxyPath = null;
            }
        }
        if (localPrefix != null && proxyPath != null && !localPrefix.equals(proxyPath)) {
            String currentPath = baseBuilder.build(new Object[0]).getPath();
            String currentRequestPath = requestBuilder.build(new Object[0]).getPath();
            String newPath = currentPath;
            if (currentPath != null && currentPath.startsWith(localPrefix)) {
                newPath = this.joinPaths(proxyPath, currentPath.substring(localPrefix.length()));
            }
            String newRequestPath = currentRequestPath;
            if (currentRequestPath != null && currentRequestPath.startsWith(localPrefix)) {
                newRequestPath = this.joinPaths(proxyPath, currentRequestPath.substring(localPrefix.length()));
            }
            this.updatePaths(ctx, baseBuilder, requestBuilder, newPath, newRequestPath);
        }
    }

    private String getFirstHeaderValueOrNull(ContainerRequestContext ctx, String headerName) {
        List headerValues = (List)ctx.getHeaders().get((Object)headerName);
        if (headerValues != null && !headerValues.isEmpty()) {
            return (String)headerValues.get(0);
        }
        return null;
    }

    private String joinPaths(String prefix, String suffix) {
        String normalizedPrefix = prefix != null && prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
        String normalizedSuffix = suffix != null && !suffix.isEmpty() && !suffix.startsWith("/") ? "/" + suffix : suffix;
        return (normalizedPrefix != null ? normalizedPrefix : "") + (normalizedSuffix != null ? normalizedSuffix : "");
    }

    private void updatePaths(ContainerRequestContext ctx, UriBuilder baseBuilder, UriBuilder requestBuilder, String basePath, String requestPath) {
        baseBuilder.replacePath(basePath);
        requestBuilder.replacePath(requestPath);
        ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
    }

    private static enum ApiContext {
        PORTAL,
        MANAGEMENT,
        UNKNOWN;

    }
}

