/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.rest.filter;

import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.MaintenanceModeException;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@Priority(value=90)
public class MaintenanceFilter
implements ContainerRequestFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    ParameterService parameterService;
    private Pattern organizationSettings = Pattern.compile("organizations/[^/]+/settings");

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean maintenanceModeEnabled = this.parameterService.findAsBoolean(GraviteeContext.getExecutionContext(), Key.MAINTENANCE_MODE_ENABLED, ParameterReferenceType.ORGANIZATION);
        if (maintenanceModeEnabled && this.organizationSettings.matcher(requestContext.getUriInfo().getPath()).matches() && "POST".equals(requestContext.getRequest().getMethod())) {
            return;
        }
        if (maintenanceModeEnabled && !requestContext.getUriInfo().getPath().equals("portal") && !requestContext.getUriInfo().getPath().equals("portal/")) {
            throw new MaintenanceModeException();
        }
    }
}

