/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import io.gravitee.common.util.TemplatedValueHashMap;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiTemplateVariables {
    private final GenericApiEntity api;

    public ApiTemplateVariables(GenericApiEntity api) {
        this.api = api;
    }

    public String getId() {
        return this.api.getId();
    }

    public String getName() {
        return this.api.getName();
    }

    public String getVersion() {
        return this.api.getApiVersion();
    }

    public Map<String, String> getProperties() {
        if (this.api != null) {
            if (DefinitionVersion.V4.equals((Object)this.api.getDefinitionVersion())) {
                io.gravitee.rest.api.model.v4.api.ApiEntity v4Api = (io.gravitee.rest.api.model.v4.api.ApiEntity)this.api;
                if (v4Api.getProperties() != null) {
                    return (Map)v4Api.getProperties().stream().collect(Collectors.toMap(Property::getKey, Property::getValue, (v1, v2) -> {
                        throw new IllegalArgumentException(String.format("Duplicate key for values %s and %s", v1, v2));
                    }, TemplatedValueHashMap::new));
                }
            } else {
                ApiEntity v2Api = (ApiEntity)this.api;
                if (v2Api.getProperties() != null) {
                    return v2Api.getProperties().getValues();
                }
            }
        }
        return Map.of();
    }
}

