/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PlanType;
import io.gravitee.rest.api.model.PlanValidationType;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NewPlanEntity {
    private String id;
    private String crossId;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private PlanValidationType validation = PlanValidationType.MANUAL;
    @NotNull
    private PlanSecurityType security = PlanSecurityType.API_KEY;
    private String securityDefinition;
    @NotNull
    private PlanType type = PlanType.API;
    @NotNull
    private PlanStatus status = PlanStatus.STAGING;
    private String api;
    @JsonProperty(value="paths", required=true)
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @JsonProperty(value="flows", required=true)
    private List<Flow> flows = new ArrayList<Flow>();
    private List<String> characteristics;
    @JsonProperty(value="excluded_groups")
    private List<String> excludedGroups;
    @JsonProperty(value="comment_required")
    private boolean commentRequired;
    @JsonProperty(value="comment_message")
    private String commentMessage;
    private Set<String> tags;
    @JsonProperty(value="selection_rule")
    private String selectionRule;
    @JsonProperty(value="general_conditions")
    private String generalConditions;
    private int order;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    public PlanValidationType getValidation() {
        return this.validation;
    }

    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    public PlanType getType() {
        return this.type;
    }

    public void setType(PlanType type) {
        this.type = type;
    }

    public PlanStatus getStatus() {
        return this.status;
    }

    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    public PlanSecurityType getSecurity() {
        return this.security;
    }

    public void setSecurity(PlanSecurityType security) {
        this.security = security;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public String getSecurityDefinition() {
        return this.securityDefinition;
    }

    public void setSecurityDefinition(String securityDefinition) {
        this.securityDefinition = securityDefinition;
    }

    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    public String getCommentMessage() {
        return this.commentMessage;
    }

    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    public String getGeneralConditions() {
        return this.generalConditions;
    }

    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewPlanEntity that = (NewPlanEntity)o;
        return this.id != null ? this.id.equals(that.id) : this.name.equals(that.name);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : this.name.hashCode();
    }
}

