/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.configuration.identity.google;

import io.gravitee.rest.api.model.configuration.identity.IdentityProviderType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleIdentityProviderEntity
extends SocialIdentityProviderEntity {
    private static final String AUTHORIZATION_URL = "https://accounts.google.com/o/oauth2/v2/auth";
    private static final String TOKEN_URL = "https://www.googleapis.com/oauth2/v4/token";
    private static final String USER_INFO_URL = "https://www.googleapis.com/oauth2/v3/userinfo";
    private static final String GOOGLE_ACCESS_TOKEN_PROPERTY = "access_token";
    private static final String GOOGLE_AUTHORIZATION_HEADER = "Bearer %s";

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.GOOGLE;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return AUTHORIZATION_URL;
    }

    @Override
    public String getTokenEndpoint() {
        return TOKEN_URL;
    }

    @Override
    public String getUserInfoEndpoint() {
        return USER_INFO_URL;
    }

    @Override
    public List<String> getRequiredUrlParams() {
        return Collections.singletonList("scope");
    }

    @Override
    public List<String> getOptionalUrlParams() {
        return Arrays.asList("display", "state");
    }

    @Override
    public List<String> getScopes() {
        return Arrays.asList("profile", "email");
    }

    @Override
    public String getDisplay() {
        return "popup";
    }

    @Override
    public String getColor() {
        return null;
    }

    @Override
    public Map<String, String> getUserProfileMapping() {
        HashMap<String, String> userProfileMapping = new HashMap<String, String>();
        userProfileMapping.put("id", "email");
        userProfileMapping.put("sub", "sub");
        userProfileMapping.put("email", "email");
        userProfileMapping.put("firstname", "given_name");
        userProfileMapping.put("lastname", "family_name");
        userProfileMapping.put("picture", "picture");
        return userProfileMapping;
    }
}

