/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Origin;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;
import lombok.Generated;

public class ApplicationEntity {
    @Schema(description="Application's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private String name;
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="if the app is ACTIVE or ARCHIVED.", example="ACTIVE")
    private String status;
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    private String picture;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the application was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the application was updated.", example="1581256457163")
    private Date updatedAt;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @JsonProperty(value="settings")
    private ApplicationSettings settings;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API Key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    private String background;
    @Schema(description="The origin used for creating this application.")
    private Origin origin;

    public boolean hasApiKeySharedMode() {
        return this.apiKeyMode == ApiKeyMode.SHARED;
    }

    @Generated
    public static ApplicationEntityBuilder builder() {
        return new ApplicationEntityBuilder();
    }

    @Generated
    public ApplicationEntityBuilder toBuilder() {
        return new ApplicationEntityBuilder().id(this.id).name(this.name).description(this.description).domain(this.domain).groups(this.groups).status(this.status).type(this.type).picture(this.picture).createdAt(this.createdAt).updatedAt(this.updatedAt).primaryOwner(this.primaryOwner).settings(this.settings).disableMembershipNotifications(this.disableMembershipNotifications).apiKeyMode(this.apiKeyMode).background(this.background).origin(this.origin);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    @Generated
    public ApplicationSettings getSettings() {
        return this.settings;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="owner")
    @Generated
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @JsonProperty(value="settings")
    @Generated
    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    @JsonProperty(value="disable_membership_notifications")
    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @JsonProperty(value="api_key_mode")
    @Generated
    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    @Generated
    public String toString() {
        return "ApplicationEntity(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", domain=" + this.getDomain() + ", groups=" + this.getGroups() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", picture=" + this.getPicture() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", primaryOwner=" + this.getPrimaryOwner() + ", settings=" + this.getSettings() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", apiKeyMode=" + this.getApiKeyMode() + ", background=" + this.getBackground() + ", origin=" + this.getOrigin() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationEntity)) {
            return false;
        }
        ApplicationEntity other = (ApplicationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public ApplicationEntity(String id, String name, String description, String domain, Set<String> groups, String status, String type, String picture, Date createdAt, Date updatedAt, PrimaryOwnerEntity primaryOwner, ApplicationSettings settings, boolean disableMembershipNotifications, ApiKeyMode apiKeyMode, String background, Origin origin) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.groups = groups;
        this.status = status;
        this.type = type;
        this.picture = picture;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.primaryOwner = primaryOwner;
        this.settings = settings;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiKeyMode = apiKeyMode;
        this.background = background;
        this.origin = origin;
    }

    @Generated
    public ApplicationEntity() {
    }

    @Generated
    public static class ApplicationEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String domain;
        @Generated
        private Set<String> groups;
        @Generated
        private String status;
        @Generated
        private String type;
        @Generated
        private String picture;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private PrimaryOwnerEntity primaryOwner;
        @Generated
        private ApplicationSettings settings;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private String background;
        @Generated
        private Origin origin;

        @Generated
        ApplicationEntityBuilder() {
        }

        @Generated
        public ApplicationEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public ApplicationEntityBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        @Generated
        public ApplicationEntityBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="owner")
        @Generated
        public ApplicationEntityBuilder primaryOwner(PrimaryOwnerEntity primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this;
        }

        @JsonProperty(value="settings")
        @Generated
        public ApplicationEntityBuilder settings(ApplicationSettings settings) {
            this.settings = settings;
            return this;
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public ApplicationEntityBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @JsonProperty(value="api_key_mode")
        @Generated
        public ApplicationEntityBuilder apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public ApplicationEntityBuilder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public ApplicationEntity build() {
            return new ApplicationEntity(this.id, this.name, this.description, this.domain, this.groups, this.status, this.type, this.picture, this.createdAt, this.updatedAt, this.primaryOwner, this.settings, this.disableMembershipNotifications, this.apiKeyMode, this.background, this.origin);
        }

        @Generated
        public String toString() {
            return "ApplicationEntity.ApplicationEntityBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", domain=" + this.domain + ", groups=" + this.groups + ", status=" + this.status + ", type=" + this.type + ", picture=" + this.picture + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", primaryOwner=" + this.primaryOwner + ", settings=" + this.settings + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiKeyMode=" + this.apiKeyMode + ", background=" + this.background + ", origin=" + this.origin + ")";
        }
    }
}

