/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.integration.controller.spring;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.gravitee.apim.core.integration.use_case.UpdateAgentStatusUseCase;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.exchange.api.configuration.IdentifyConfiguration;
import io.gravitee.exchange.api.controller.ControllerCommandHandlersFactory;
import io.gravitee.exchange.api.controller.ExchangeController;
import io.gravitee.exchange.api.controller.listeners.TargetListener;
import io.gravitee.exchange.api.websocket.command.ExchangeSerDe;
import io.gravitee.exchange.controller.websocket.WebSocketExchangeController;
import io.gravitee.exchange.controller.websocket.auth.WebSocketControllerAuthentication;
import io.gravitee.integration.api.websocket.command.IntegrationExchangeSerDe;
import io.gravitee.integration.controller.command.IntegrationControllerCommandHandlerFactory;
import io.gravitee.integration.controller.listener.ControllerEventListener;
import io.gravitee.integration.controller.spring.IntegrationControllerCondition;
import io.gravitee.integration.controller.websocket.auth.IntegrationWebsocketControllerAuthentication;
import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.api.certificate.KeyStoreLoaderFactoryRegistry;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.api.certificate.TrustStoreLoaderOptions;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.gravitee.rest.api.service.TokenService;
import io.vertx.rxjava3.core.Vertx;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={IntegrationControllerCondition.class})
public class IntegrationControllerConfiguration {
    @Bean(value={"integrationWebsocketControllerAuthentication"})
    public IntegrationWebsocketControllerAuthentication integrationWebsocketControllerAuthentication(TokenService tokenService, UserCrudService userCrudService, LicenseDomainService licenseDomainService) {
        return new IntegrationWebsocketControllerAuthentication(tokenService, userCrudService, licenseDomainService);
    }

    @Bean(value={"integrationExchangeSerDe"})
    public IntegrationExchangeSerDe integrationExchangeSerDe() {
        return new IntegrationExchangeSerDe(this.objectMapper());
    }

    @Bean(value={"integrationIdentifyConfiguration"})
    public IdentifyConfiguration integrationPrefixConfiguration(Environment environment) {
        return new IdentifyConfiguration(environment, "integration");
    }

    @Bean(value={"integrationControllerCommandHandlerFactory"})
    public IntegrationControllerCommandHandlerFactory integrationControllerCommandHandlerFactory(UpdateAgentStatusUseCase updateAgentStatusUseCase) {
        return new IntegrationControllerCommandHandlerFactory(updateAgentStatusUseCase);
    }

    @Bean(value={"integrationControllerEventListener"})
    ControllerEventListener controllerEventListener(UpdateAgentStatusUseCase updateAgentStatusUseCase) {
        return new ControllerEventListener(updateAgentStatusUseCase);
    }

    @Bean(value={"integrationExchangeController"})
    public ExchangeController integrationExchangeController(@Lazy ClusterManager clusterManager, @Lazy CacheManager cacheManager, @Lazy ManagementEndpointManager managementEndpointManager, Vertx vertx, KeyStoreLoaderFactoryRegistry<KeyStoreLoaderOptions> keyStoreLoaderFactoryRegistry, KeyStoreLoaderFactoryRegistry<TrustStoreLoaderOptions> trustStoreLoaderFactoryRegistry, @Qualifier(value="integrationIdentifyConfiguration") IdentifyConfiguration identifyConfiguration, @Qualifier(value="integrationWebsocketControllerAuthentication") WebSocketControllerAuthentication<?> integrationWebsocketControllerAuthentication, @Qualifier(value="integrationControllerCommandHandlerFactory") ControllerCommandHandlersFactory integrationControllerCommandHandlerFactory, @Qualifier(value="integrationExchangeSerDe") ExchangeSerDe integrationExchangeSerDe, @Qualifier(value="integrationControllerEventListener") ControllerEventListener eventListener) {
        return new WebSocketExchangeController(identifyConfiguration, clusterManager, cacheManager, managementEndpointManager, vertx, keyStoreLoaderFactoryRegistry, trustStoreLoaderFactoryRegistry, integrationWebsocketControllerAuthentication, integrationControllerCommandHandlerFactory, integrationExchangeSerDe).addListener((TargetListener)eventListener);
    }

    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }
}

