/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.fetcher.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.rest.api.fetcher.FetcherConfigurationFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherConfigurationFactoryImpl
implements FetcherConfigurationFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(FetcherConfigurationFactoryImpl.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    public <T extends FetcherConfiguration> T create(Class<T> fetcherConfigurationClass, String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            this.LOGGER.error("Unable to create a Fetcher configuration from a null or empty configuration data");
            return null;
        }
        try {
            return (T)((FetcherConfiguration)this.mapper.readValue(configuration, fetcherConfigurationClass));
        }
        catch (IOException ex) {
            this.LOGGER.error("Unable to instance Fetcher configuration for {}", (Object)fetcherConfigurationClass.getName(), (Object)ex);
            return null;
        }
    }
}

