/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.analytics.query;

import io.gravitee.repository.analytics.query.AbstractQuery;
import io.gravitee.repository.analytics.query.DateRange;
import io.gravitee.repository.analytics.query.Interval;
import io.gravitee.repository.analytics.query.QueryBuilder;
import io.gravitee.repository.analytics.query.QueryFilter;
import io.gravitee.repository.analytics.query.RootFilter;
import io.gravitee.repository.analytics.query.TimeRangeFilter;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder, Q extends AbstractQuery>
implements QueryBuilder {
    protected final Q query;

    protected AbstractQueryBuilder(Q query) {
        this.query = query;
    }

    public Q build() {
        return this.query;
    }

    public QB query(String query) {
        if (query != null) {
            ((AbstractQuery)this.query).query(new QueryFilter(query));
        }
        return (QB)this;
    }

    public QB timeRange(DateRange dateRange, Interval interval) {
        ((AbstractQuery)this.query).timeRange(new TimeRangeFilter(dateRange, interval));
        return (QB)this;
    }

    public QB root(String field, String id) {
        if (field != null && id != null) {
            ((AbstractQuery)this.query).root(new RootFilter(field, id));
        }
        return (QB)this;
    }
}

