/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.entrypoint.internal;

import io.gravitee.gateway.reactive.api.connector.entrypoint.EntrypointConnectorFactory;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.entrypoint.EntrypointConnectorClassLoaderFactory;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntrypointConnectorPluginManager
extends AbstractConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>>
implements EntrypointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntrypointConnectorPluginManager.class);
    private final EntrypointConnectorClassLoaderFactory classLoaderFactory;
    private final PluginConfigurationHelper pluginConfigurationHelper;
    private final Map<String, EntrypointConnectorFactory<?>> factories = new HashMap();
    private final Map<String, EntrypointConnectorFactory<?>> notDeployedPluginFactories = new HashMap();

    public DefaultEntrypointConnectorPluginManager(EntrypointConnectorClassLoaderFactory classLoaderFactory, PluginConfigurationHelper pluginConfigurationHelper) {
        this.classLoaderFactory = classLoaderFactory;
        this.pluginConfigurationHelper = pluginConfigurationHelper;
    }

    public void register(EntrypointConnectorPlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            EntrypointConnectorFactory<?> factory = this.createFactory(connectorFactoryClass);
            if (plugin.deployed()) {
                this.factories.put(plugin.id(), factory);
            } else {
                this.notDeployedPluginFactories.put(plugin.id(), factory);
            }
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading entrypoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private EntrypointConnectorFactory<?> createFactory(Class<EntrypointConnectorFactory<?>> connectorFactoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        EntrypointConnectorFactory<?> factory;
        try {
            Constructor<EntrypointConnectorFactory<?>> constructorWithConfigurationHelper = connectorFactoryClass.getDeclaredConstructor(PluginConfigurationHelper.class);
            factory = constructorWithConfigurationHelper.newInstance(this.pluginConfigurationHelper);
        }
        catch (NoSuchMethodException e) {
            Constructor<EntrypointConnectorFactory<?>> emptyConstructor = connectorFactoryClass.getDeclaredConstructor(new Class[0]);
            factory = emptyConstructor.newInstance(new Object[0]);
        }
        return factory;
    }

    public EntrypointConnectorFactory<?> getFactoryById(String entrypointPluginId) {
        return this.factories.get(entrypointPluginId);
    }

    public EntrypointConnectorFactory<?> getFactoryById(String entrypointPluginId, boolean includeNotDeployed) {
        EntrypointConnectorFactory<?> factory = this.factories.get(entrypointPluginId);
        if (factory == null && includeNotDeployed) {
            return this.notDeployedPluginFactories.get(entrypointPluginId);
        }
        return factory;
    }

    @Override
    public String getSubscriptionSchema(String pluginId) throws IOException {
        return this.getSubscriptionSchema(pluginId, false);
    }

    @Override
    public String getSubscriptionSchema(String pluginId, boolean includeNotDeployed) throws IOException {
        return this.getSchema(pluginId, "subscriptions", includeNotDeployed);
    }
}

