/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.tcp.proxy.client;

import io.gravitee.apim.common.mapper.SslOptionsMapper;
import io.gravitee.apim.common.mapper.TcpClientOptionsMapper;
import io.gravitee.apim.common.mapper.TcpProxyOptionsMapper;
import io.gravitee.apim.common.mapper.TcpTargetMapper;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.node.vertx.client.tcp.VertxTcpClientFactory;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorSharedConfiguration;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.net.NetClient;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpClientFactory {
    private NetClient tcpClient;
    private final AtomicBoolean tcpClientCreated = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetClient getOrBuildTcpClient(ExecutionContext ctx, TcpProxyEndpointConnectorConfiguration configuration, TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        if (this.tcpClient == null) {
            TcpClientFactory tcpClientFactory = this;
            synchronized (tcpClientFactory) {
                if (this.tcpClientCreated.compareAndSet(false, true)) {
                    this.tcpClient = this.buildTcpClient(ctx, configuration, sharedConfiguration).build().createTcpClient();
                }
            }
        }
        return this.tcpClient;
    }

    protected VertxTcpClientFactory.VertxTcpClientFactoryBuilder buildTcpClient(ExecutionContext ctx, TcpProxyEndpointConnectorConfiguration configuration, TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        return VertxTcpClientFactory.builder().vertx((Vertx)ctx.getComponent(Vertx.class)).tcpTarget(TcpTargetMapper.INSTANCE.map(configuration.getTcpTarget())).sslOptions(SslOptionsMapper.INSTANCE.map(sharedConfiguration.getSslOptions())).proxyOptions(TcpProxyOptionsMapper.INSTANCE.map(sharedConfiguration.getProxyOptions())).tcpOptions(TcpClientOptionsMapper.INSTANCE.map(sharedConfiguration.getTcpClientOptions())).nodeConfiguration((Configuration)ctx.getComponent(Configuration.class));
    }

    public void close() {
        if (this.tcpClient != null) {
            this.tcpClient.close();
            this.tcpClient = null;
        }
    }
}

