/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.internal;

import io.gravitee.gateway.jupiter.api.connector.AbstractConnectorFactory;
import io.gravitee.gateway.jupiter.api.connector.endpoint.EndpointConnector;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.endpoint.EndpointConnectorClassLoaderFactory;
import io.gravitee.plugin.endpoint.EndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.EndpointConnectorPluginManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointConnectorPluginManager
extends AbstractConfigurablePluginManager<EndpointConnectorPlugin<?>>
implements EndpointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointConnectorPluginManager.class);
    private final EndpointConnectorClassLoaderFactory classLoaderFactory;
    private final Map<String, AbstractConnectorFactory<? extends EndpointConnector>> factories = new HashMap<String, AbstractConnectorFactory<? extends EndpointConnector>>();

    public DefaultEndpointConnectorPluginManager(EndpointConnectorClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    public void register(EndpointConnectorPlugin<?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            AbstractConnectorFactory factory = (AbstractConnectorFactory)connectorFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.factories.put(plugin.id(), (AbstractConnectorFactory<? extends EndpointConnector>)factory);
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading endpoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    @Override
    public <T extends AbstractConnectorFactory<U>, U extends EndpointConnector> T getFactoryById(String endpointPluginId) {
        return (T)this.factories.get(endpointPluginId);
    }
}

