/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.debug.DebugApiV2;
import io.gravitee.definition.model.debug.DebugApiV4;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.gateway.debug.definition.ReactableDebugApi;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.handlers.accesspoint.manager.AccessPointManager;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.ReactorEvent;
import io.gravitee.gateway.reactor.accesspoint.ReactableAccessPoint;
import io.gravitee.gateway.reactor.handler.ReactorEventListener;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.impl.ReactableEvent;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.gravitee.secrets.api.discovery.DefinitionMetadata;
import io.gravitee.secrets.api.event.SecretDiscoveryEvent;
import io.gravitee.secrets.api.event.SecretDiscoveryEventType;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import io.vertx.rxjava3.core.http.HttpClientResponse;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReactorEventListener
extends ReactorEventListener {
    private final Logger logger = LoggerFactory.getLogger(DebugReactorEventListener.class);
    private final Vertx vertx;
    private final EventRepository eventRepository;
    private final ObjectMapper objectMapper;
    private final VertxDebugHttpClientConfiguration debugHttpClientConfiguration;
    private final AccessPointManager accessPointManager;
    private final DataEncryptor dataEncryptor;

    public DebugReactorEventListener(Vertx vertx, EventManager eventManager, EventRepository eventRepository, ObjectMapper objectMapper, VertxDebugHttpClientConfiguration debugHttpClientConfiguration, ReactorHandlerRegistry reactorHandlerRegistry, AccessPointManager accessPointManager, DataEncryptor dataEncryptor) {
        super(eventManager, reactorHandlerRegistry);
        this.vertx = vertx;
        this.eventRepository = eventRepository;
        this.objectMapper = objectMapper;
        this.debugHttpClientConfiguration = debugHttpClientConfiguration;
        this.accessPointManager = accessPointManager;
        this.dataEncryptor = dataEncryptor;
    }

    public void onEvent(io.gravitee.common.event.Event<ReactorEvent, Reactable> reactorEvent) {
        if (reactorEvent.type() == ReactorEvent.DEBUG) {
            this.logger.info("Deploying api for debug");
            ReactableEvent reactableEvent = (ReactableEvent)reactorEvent.content();
            Event debugEvent = (Event)reactableEvent.getContent();
            ReactableDebugApi<?> debugApi = this.toDebugApi((ReactableEvent<Event>)reactableEvent);
            if (debugApi != null) {
                if (this.reactorHandlerRegistry.contains(debugApi)) {
                    this.logger.info("Api for debug already deployed. No need to do it again.");
                    return;
                }
                this.reactorHandlerRegistry.create(debugApi);
                SecretDiscoveryEvent secretDiscoveryEvent = new SecretDiscoveryEvent(debugApi.getEnvironmentId(), debugApi.getDefinition(), new DefinitionMetadata(debugApi.getRevision()));
                this.eventManager.publishEvent((Enum)SecretDiscoveryEventType.DISCOVER, (Object)secretDiscoveryEvent);
                HttpRequest debugApiRequest = debugApi.getRequest();
                this.updateEvent(debugEvent, ApiDebugStatus.DEBUGGING).andThen((CompletableSource)Completable.defer(() -> {
                    this.logger.info("Sending request to debug");
                    HttpClient httpClient = this.vertx.createHttpClient(this.buildClientOptions());
                    return httpClient.rxRequest(new RequestOptions().setMethod(HttpMethod.valueOf((String)debugApiRequest.getMethod())).setHeaders(this.buildHeaders(debugApi, debugApiRequest)).setURI(debugApi.extractUri()).setTimeout((long)this.debugHttpClientConfiguration.getRequestTimeout())).map(httpClientRequest -> httpClientRequest.setChunked(true)).flatMap(httpClientRequest -> debugApiRequest.getBody() == null ? httpClientRequest.rxSend() : httpClientRequest.rxSend(debugApiRequest.getBody())).doOnSuccess(httpClientResponse -> this.logger.debug("Response status: {}", (Object)httpClientResponse.statusCode())).flatMap(HttpClientResponse::rxBody).doFinally(() -> ((HttpClient)httpClient).close()).ignoreElement();
                })).subscribeOn(Schedulers.io()).subscribe(() -> {
                    this.logger.info("Debugging successful, removing the handler.");
                    this.eventManager.publishEvent((Enum)SecretDiscoveryEventType.REVOKE, (Object)secretDiscoveryEvent);
                    this.reactorHandlerRegistry.remove((Reactable)debugApi);
                }, throwable -> {
                    this.logger.error("Debugging API has failed, removing the handler.", throwable);
                    this.eventManager.publishEvent((Enum)SecretDiscoveryEventType.REVOKE, (Object)secretDiscoveryEvent);
                    this.reactorHandlerRegistry.remove((Reactable)debugApi);
                    this.failEvent(debugEvent);
                });
            }
        }
    }

    private ReactableDebugApi<?> toDebugApi(ReactableEvent<Event> reactableEvent) {
        Event event = (Event)reactableEvent.getContent();
        try {
            if (event.getProperties().getOrDefault("definition_version", "V2").equals("V4")) {
                return this.toDebugApiV4(reactableEvent);
            }
            DebugApiV2 eventDebugApi = (DebugApiV2)this.objectMapper.readValue(event.getPayload(), DebugApiV2.class);
            if (null != eventDebugApi.getProperties()) {
                this.decryptProperties(eventDebugApi.getProperties());
            }
            eventDebugApi.setPlans(eventDebugApi.getPlans().stream().filter(plan -> !PlanStatus.CLOSED.name().equalsIgnoreCase(plan.getStatus())).toList());
            io.gravitee.gateway.debug.definition.DebugApiV2 debugApi = new io.gravitee.gateway.debug.definition.DebugApiV2(reactableEvent.getId(), eventDebugApi);
            debugApi.setDeployedAt(reactableEvent.getDeployedAt());
            debugApi.setEnvironmentHrid(reactableEvent.getEnvironmentHrid());
            debugApi.setEnvironmentId(reactableEvent.getEnvironmentId());
            debugApi.setOrganizationHrid(reactableEvent.getOrganizationHrid());
            debugApi.setOrganizationId(reactableEvent.getOrganizationId());
            return debugApi;
        }
        catch (Exception e) {
            this.logger.error("Unable to extract api definition from event [{}].", (Object)reactableEvent.getId(), (Object)e);
            this.failEvent(event);
            return null;
        }
    }

    private ReactableDebugApi<?> toDebugApiV4(ReactableEvent<Event> reactableEvent) {
        Event event = (Event)reactableEvent.getContent();
        try {
            DebugApiV4 eventDebugApi = (DebugApiV4)this.objectMapper.readValue(event.getPayload(), DebugApiV4.class);
            if (null != eventDebugApi.getApiDefinition().getProperties()) {
                this.decryptProperties(eventDebugApi.getApiDefinition().getProperties());
            }
            eventDebugApi.getApiDefinition().setPlans(eventDebugApi.getApiDefinition().getPlans().stream().filter(plan -> !PlanStatus.CLOSED.equals((Object)plan.getStatus())).toList());
            io.gravitee.gateway.debug.definition.DebugApiV4 debugApi = new io.gravitee.gateway.debug.definition.DebugApiV4(reactableEvent.getId(), eventDebugApi);
            debugApi.setDeployedAt(reactableEvent.getDeployedAt());
            debugApi.setEnvironmentHrid(reactableEvent.getEnvironmentHrid());
            debugApi.setEnvironmentId(reactableEvent.getEnvironmentId());
            debugApi.setOrganizationHrid(reactableEvent.getOrganizationHrid());
            debugApi.setOrganizationId(reactableEvent.getOrganizationId());
            return debugApi;
        }
        catch (Exception e) {
            this.logger.error("Unable to extract api definition from event [{}].", (Object)reactableEvent.getId(), (Object)e);
            this.failEvent(event);
            return null;
        }
    }

    private HttpClientOptions buildClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(this.debugHttpClientConfiguration.getHost());
        options.setDefaultPort(this.debugHttpClientConfiguration.getPort());
        options.setConnectTimeout(this.debugHttpClientConfiguration.getConnectTimeout());
        options.setDecompressionSupported(this.debugHttpClientConfiguration.isCompressionSupported());
        options.setUseAlpn(this.debugHttpClientConfiguration.isAlpn());
        options.setVerifyHost(false);
        if (this.debugHttpClientConfiguration.isSecured()) {
            options.setSsl(this.debugHttpClientConfiguration.isSecured());
            options.setTrustAll(true);
            options.setVerifyHost(false);
            if (this.debugHttpClientConfiguration.isOpenssl()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
        }
        return options;
    }

    MultiMap buildHeaders(ReactableDebugApi<?> debugApi, HttpRequest req) {
        List accessPoints;
        HeadersMultiMap headers = new HeadersMultiMap();
        headers.addAll(this.convertHeaders(req.getHeaders()));
        String host = debugApi.extractHost();
        if (host == null && (accessPoints = this.accessPointManager.getByEnvironmentId(debugApi.getEnvironmentId())) != null && !accessPoints.isEmpty()) {
            host = ((ReactableAccessPoint)accessPoints.getFirst()).getHost();
        }
        if (host != null) {
            headers.add("Host", host);
        }
        return headers;
    }

    MultiMap convertHeaders(Map<String, List<String>> headers) {
        HeadersMultiMap headersMultiMap = new HeadersMultiMap();
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HeadersMultiMap)headersMultiMap).set(arg_0, arg_1));
        }
        return headersMultiMap;
    }

    private void failEvent(Event debugEvent) {
        if (debugEvent != null) {
            this.updateEvent(debugEvent, ApiDebugStatus.ERROR).subscribeOn(Schedulers.io()).subscribe(() -> {}, throwable -> this.logger.error("Failed to update event {} to ERROR status", (Object)debugEvent.getId(), throwable));
        }
    }

    private Completable updateEvent(Event debugEvent, ApiDebugStatus apiDebugStatus) {
        return Completable.fromAction(() -> {
            debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
            this.eventRepository.update((Object)debugEvent);
        });
    }

    private void decryptProperties(Properties properties) {
        for (io.gravitee.definition.model.Property property : properties.getProperties()) {
            if (!property.isEncrypted()) continue;
            try {
                property.setValue(this.dataEncryptor.decrypt(property.getValue()));
                property.setEncrypted(false);
                properties.getValues().put(property.getKey(), property.getValue());
            }
            catch (GeneralSecurityException e) {
                this.logger.error("Error decrypting API property value for key {}", (Object)property.getKey(), (Object)e);
            }
        }
    }

    private void decryptProperties(List<Property> properties) {
        properties.forEach(property -> {
            if (property.isEncrypted()) {
                try {
                    property.setValue(this.dataEncryptor.decrypt(property.getValue()));
                    property.setEncrypted(false);
                }
                catch (GeneralSecurityException e) {
                    this.logger.error("Error decrypting API property value for key {}", (Object)property.getKey(), (Object)e);
                }
            }
        });
    }
}

