/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.organization.event;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.platform.organization.event.OrganizationEvent;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorRegistry;
import java.util.Objects;

public class DebugOrganizationEventListener
extends AbstractService<DebugOrganizationEventListener>
implements EventListener<OrganizationEvent, ReactableOrganization> {
    private final OrganizationReactorRegistry v3OrganizationReactorRegistry;
    private final OrganizationReactorRegistry organizationReactorRegistry;

    public DebugOrganizationEventListener(EventManager eventManager, OrganizationReactorRegistry debugV3OrganizationReactorRegistry, OrganizationReactorRegistry debugOrganizationReactorRegistry) {
        this.v3OrganizationReactorRegistry = debugV3OrganizationReactorRegistry;
        this.organizationReactorRegistry = debugOrganizationReactorRegistry;
        eventManager.subscribeForEvents((EventListener)this, OrganizationEvent.class);
    }

    public void onEvent(Event<OrganizationEvent, ReactableOrganization> event) {
        OrganizationEvent type = (OrganizationEvent)event.type();
        if (Objects.requireNonNull(type) == OrganizationEvent.REGISTER) {
            this.v3OrganizationReactorRegistry.create((ReactableOrganization)event.content());
            this.organizationReactorRegistry.create((ReactableOrganization)event.content());
        } else if (type == OrganizationEvent.UNREGISTER) {
            this.v3OrganizationReactorRegistry.remove((ReactableOrganization)event.content());
            this.organizationReactorRegistry.remove((ReactableOrganization)event.content());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.v3OrganizationReactorRegistry.clear();
        this.organizationReactorRegistry.clear();
    }
}

