/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.http.IdGenerator;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.condition.ConditionEvaluator;
import io.gravitee.gateway.core.condition.ExpressionLanguageStringConditionEvaluator;
import io.gravitee.gateway.debug.handlers.api.DebugApiReactorHandlerFactory;
import io.gravitee.gateway.debug.organization.event.DebugOrganizationEventListener;
import io.gravitee.gateway.debug.organization.reactor.DebugOrganizationReactorFactory;
import io.gravitee.gateway.debug.policy.impl.DebugPolicyFactory;
import io.gravitee.gateway.debug.policy.impl.PolicyDebugDecoratorFactoryCreator;
import io.gravitee.gateway.debug.reactor.DebugReactor;
import io.gravitee.gateway.debug.reactor.processor.DebugResponseProcessorChainFactory;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.debug.vertx.VertxDebugService;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.env.RequestClientAuthConfiguration;
import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.handlers.accesspoint.manager.AccessPointManager;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.platform.organization.flow.OrganizationFlowResolver;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import io.gravitee.gateway.platform.organization.policy.V3OrganizationPolicyChainFactoryManager;
import io.gravitee.gateway.platform.organization.providers.OnRequestPlatformPolicyChainProvider;
import io.gravitee.gateway.platform.organization.providers.OnResponsePlatformPolicyChainProvider;
import io.gravitee.gateway.platform.organization.reactor.V3OrganizationReactorFactory;
import io.gravitee.gateway.policy.ConfigurablePolicyChainProvider;
import io.gravitee.gateway.policy.PolicyChainProviderLoader;
import io.gravitee.gateway.policy.PolicyFactoryCreator;
import io.gravitee.gateway.policy.PolicyPluginFactory;
import io.gravitee.gateway.policy.impl.PolicyFactoryCreatorImpl;
import io.gravitee.gateway.reactive.debug.DebugReactorEventListener;
import io.gravitee.gateway.reactive.debug.policy.condition.DebugExpressionLanguageConditionFilter;
import io.gravitee.gateway.reactive.debug.reactor.DebugHttpRequestDispatcher;
import io.gravitee.gateway.reactive.debug.reactor.processor.DebugPlatformProcessorChainFactory;
import io.gravitee.gateway.reactive.handlers.api.flow.resolver.FlowResolverFactory;
import io.gravitee.gateway.reactive.handlers.api.processor.ApiProcessorChainFactory;
import io.gravitee.gateway.reactive.platform.organization.policy.DefaultPlatformPolicyChainFactoryManager;
import io.gravitee.gateway.reactive.platform.organization.policy.OrganizationPolicyChainFactoryManager;
import io.gravitee.gateway.reactive.platform.organization.reactor.DefaultOrganizationReactorFactory;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorFactory;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorRegistry;
import io.gravitee.gateway.reactive.policy.HttpPolicyFactory;
import io.gravitee.gateway.reactive.policy.PolicyFactory;
import io.gravitee.gateway.reactive.policy.PolicyFactoryManager;
import io.gravitee.gateway.reactive.reactor.HttpRequestDispatcher;
import io.gravitee.gateway.reactive.reactor.handler.DefaultHttpAcceptorResolver;
import io.gravitee.gateway.reactive.reactor.handler.HttpAcceptorResolver;
import io.gravitee.gateway.reactive.reactor.processor.transaction.TransactionPreProcessorFactory;
import io.gravitee.gateway.reactive.reactor.v4.reactor.ReactorFactory;
import io.gravitee.gateway.reactive.reactor.v4.reactor.ReactorFactoryManager;
import io.gravitee.gateway.reactor.Reactor;
import io.gravitee.gateway.reactor.handler.AcceptorResolver;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.handler.impl.DefaultAcceptorResolver;
import io.gravitee.gateway.reactor.handler.impl.DefaultReactorHandlerRegistry;
import io.gravitee.gateway.reactor.processor.NotFoundProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.RequestProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.ResponseProcessorChainFactory;
import io.gravitee.gateway.report.ReporterService;
import io.gravitee.node.api.Node;
import io.gravitee.node.opentelemetry.configuration.OpenTelemetryConfiguration;
import io.gravitee.plugin.alert.AlertEventProducer;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.repository.management.api.EventRepository;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DebugConfiguration {
    private final ApplicationContext applicationContext;
    private final Node node;
    private final io.gravitee.node.api.configuration.Configuration configuration;

    public DebugConfiguration(ApplicationContext applicationContext, Node node, io.gravitee.node.api.configuration.Configuration configuration) {
        this.applicationContext = applicationContext;
        this.node = node;
        this.configuration = configuration;
    }

    @Bean
    public DebugOrganizationEventListener debugOrganizationEventListener(EventManager eventManager, OrganizationReactorRegistry debugV3OrganizationReactorRegistry, OrganizationReactorRegistry debugOrganizationReactorRegistry) {
        return new DebugOrganizationEventListener(eventManager, debugV3OrganizationReactorRegistry, debugOrganizationReactorRegistry);
    }

    @Bean
    public PolicyFactoryCreator debugV3PolicyFactoryCreator(PolicyPluginFactory policyPluginFactory) {
        return new PolicyDebugDecoratorFactoryCreator((PolicyFactoryCreator)new PolicyFactoryCreatorImpl(policyPluginFactory, (ConditionEvaluator)new ExpressionLanguageStringConditionEvaluator(), false));
    }

    @Bean
    public V3OrganizationReactorFactory debugV3OrganizationReactorFactory(DefaultClassLoader classLoader, @Qualifier(value="debugV3PolicyFactoryCreator") PolicyFactoryCreator factoryCreator, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider, ResourceClassLoaderFactory resourceClassLoaderFactory) {
        return new V3OrganizationReactorFactory(((Boolean)this.configuration.getProperty("classloader.legacy.enabled", Boolean.class, (Object)false)).booleanValue(), classLoader, this.applicationContext.getParent(), factoryCreator, policyClassLoaderFactory, componentProvider, resourceClassLoaderFactory);
    }

    @Bean
    public OrganizationReactorRegistry debugV3OrganizationReactorRegistry(@Qualifier(value="debugV3OrganizationReactorFactory") V3OrganizationReactorFactory debugV3OrganizationReactorFactory) {
        return new OrganizationReactorRegistry((OrganizationReactorFactory)debugV3OrganizationReactorFactory);
    }

    @Bean
    public io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager debugV3OrganizationPolicyChainFactoryManager(@Qualifier(value="debugV3OrganizationReactorRegistry") OrganizationReactorRegistry debugV3OrganizationReactorRegistry) {
        return new V3OrganizationPolicyChainFactoryManager(debugV3OrganizationReactorRegistry);
    }

    @Bean
    @Qualifier(value="debugV3ConfigurablePolicyChainProvider")
    public OnRequestPlatformPolicyChainProvider debugV3OnRequestPlatformPolicyChainProvider(OrganizationFlowResolver organizationFlowResolver, @Qualifier(value="debugV3OrganizationPolicyChainFactoryManager") io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager debugV3OrganizationPolicyChainFactoryManager) {
        return new OnRequestPlatformPolicyChainProvider((FlowResolver)organizationFlowResolver, debugV3OrganizationPolicyChainFactoryManager, new FlowPolicyResolverFactory());
    }

    @Bean
    @Qualifier(value="debugV3ConfigurablePolicyChainProvider")
    public OnResponsePlatformPolicyChainProvider debugV3OnResponsePlatformPolicyChainProvider(OrganizationFlowResolver organizationFlowResolver, @Qualifier(value="debugV3OrganizationPolicyChainFactoryManager") io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager debugV3OrganizationPolicyChainFactoryManager) {
        return new OnResponsePlatformPolicyChainProvider((FlowResolver)organizationFlowResolver, debugV3OrganizationPolicyChainFactoryManager, new FlowPolicyResolverFactory());
    }

    @Bean
    public AcceptorResolver debugV3EntrypointResolver(@Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry reactorHandlerRegistry) {
        return new DefaultAcceptorResolver(reactorHandlerRegistry);
    }

    @Bean
    public Reactor debugReactor(@Qualifier(value="debugV3EntrypointResolver") AcceptorResolver acceptorResolver, GatewayConfiguration gatewayConfiguration, @Qualifier(value="v3RequestProcessorChainFactory") RequestProcessorChainFactory requestProcessorChainFactory, @Qualifier(value="debugV3ResponseProcessorChainFactory") ResponseProcessorChainFactory responseProcessorChainFactory, @Qualifier(value="v3NotFoundProcessorChainFactory") NotFoundProcessorChainFactory notFoundProcessorChainFactory) {
        return new DebugReactor(acceptorResolver, gatewayConfiguration, requestProcessorChainFactory, responseProcessorChainFactory, notFoundProcessorChainFactory);
    }

    @Bean
    public PolicyChainProviderLoader debugV3PolicyChainProviderLoader(@Qualifier(value="debugV3ConfigurablePolicyChainProvider") List<ConfigurablePolicyChainProvider> providers) {
        return new PolicyChainProviderLoader(providers);
    }

    @Bean
    public ResponseProcessorChainFactory debugV3ResponseProcessorChainFactory(EventRepository eventRepository, ObjectMapper objectMapper) {
        return new DebugResponseProcessorChainFactory(eventRepository, objectMapper);
    }

    @Bean
    public DefaultOrganizationReactorFactory debugOrganizationReactorFactory(DefaultClassLoader classLoader, PolicyFactoryManager policyFactoryManager, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider, OpenTelemetryConfiguration configuration) {
        return new DebugOrganizationReactorFactory(classLoader, this.applicationContext.getParent(), policyFactoryManager, policyClassLoaderFactory, componentProvider, configuration);
    }

    @Bean
    public OrganizationReactorRegistry debugOrganizationReactorRegistry(@Qualifier(value="debugOrganizationReactorFactory") OrganizationReactorFactory defaultOrganizationReactorFactory) {
        return new OrganizationReactorRegistry(defaultOrganizationReactorFactory);
    }

    @Bean
    public OrganizationPolicyChainFactoryManager debugOrganizationPolicyChainFactoryManager(@Qualifier(value="debugOrganizationReactorRegistry") OrganizationReactorRegistry platformPolicyManagerRegistry) {
        return new DefaultPlatformPolicyChainFactoryManager(platformPolicyManagerRegistry);
    }

    @Bean
    public DebugReactorEventListener debugReactorEventListener(io.vertx.rxjava3.core.Vertx vertx, EventManager eventManager, EventRepository eventRepository, ObjectMapper objectMapper, VertxDebugHttpClientConfiguration debugHttpClientConfiguration, @Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry reactorHandlerRegistry, AccessPointManager accessPointManager, DataEncryptor dataEncryptor) {
        return new DebugReactorEventListener(vertx, eventManager, eventRepository, objectMapper, debugHttpClientConfiguration, reactorHandlerRegistry, accessPointManager, dataEncryptor);
    }

    @Bean
    public PolicyFactoryManager debugPolicyFactoryManager(Set<PolicyFactory> policyFactories) {
        return new PolicyFactoryManager(DebugPolicyFactory.class, HttpPolicyFactory.class, policyFactories);
    }

    @Bean
    public PolicyFactory debugPolicyFactory(PolicyPluginFactory policyPluginFactory) {
        return new DebugPolicyFactory(this.configuration, policyPluginFactory, new DebugExpressionLanguageConditionFilter());
    }

    @Bean
    public HttpRequestDispatcher debugHttpRequestDispatcher(GatewayConfiguration gatewayConfiguration, @Qualifier(value="debugHttpAcceptorResolver") HttpAcceptorResolver httpAcceptorResolver, IdGenerator idGenerator, ComponentProvider globalComponentProvider, RequestProcessorChainFactory v3RequestProcessorChainFactory, @Qualifier(value="debugV3ResponseProcessorChainFactory") ResponseProcessorChainFactory v3ResponseProcessorChainFactory, @Qualifier(value="debugPlatformProcessorChainFactory") DebugPlatformProcessorChainFactory debugPlatformProcessorChainFactory, io.gravitee.gateway.reactive.reactor.processor.NotFoundProcessorChainFactory notFoundProcessorChainFactory, RequestTimeoutConfiguration requestTimeoutConfiguration, RequestClientAuthConfiguration requestClientAuthConfiguration, Vertx vertx) {
        return new DebugHttpRequestDispatcher(gatewayConfiguration, httpAcceptorResolver, idGenerator, globalComponentProvider, v3RequestProcessorChainFactory, v3ResponseProcessorChainFactory, debugPlatformProcessorChainFactory, notFoundProcessorChainFactory, requestTimeoutConfiguration, requestClientAuthConfiguration, vertx);
    }

    @Bean
    public HttpAcceptorResolver debugHttpAcceptorResolver(@Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry debugReactorHandlerRegistry) {
        return new DefaultHttpAcceptorResolver(debugReactorHandlerRegistry);
    }

    @Bean
    public DebugPlatformProcessorChainFactory debugPlatformProcessorChainFactory(TransactionPreProcessorFactory transactionHandlerFactory, @Value(value="${handlers.request.trace-context.enabled:false}") boolean traceContext, @Value(value="${handlers.request.x-forward.enabled:false}") boolean xForwardProcessor, ReporterService reporterService, AlertEventProducer eventProducer, Node node, @Value(value="${debug.http.port:8482}") String httpPort, GatewayConfiguration gatewayConfiguration, EventRepository eventRepository, ObjectMapper objectMapper) {
        return new DebugPlatformProcessorChainFactory(transactionHandlerFactory, traceContext, xForwardProcessor, reporterService, eventProducer, node, httpPort, false, gatewayConfiguration, eventRepository, objectMapper);
    }

    @Bean
    public VertxDebugService vertxDebugService() {
        return new VertxDebugService();
    }

    @Bean
    public ReactorFactory<Api> debugReactorHandlerFactory(@Qualifier(value="debugV3PolicyFactoryCreator") PolicyFactoryCreator v3PolicyFactoryCreator, @Qualifier(value="debugPolicyFactoryManager") PolicyFactoryManager policyFactoryManager, @Qualifier(value="debugOrganizationPolicyChainFactoryManager") OrganizationPolicyChainFactoryManager debugOrganizationPolicyChainFactoryManager, OrganizationManager organizationManager, @Qualifier(value="debugV3PolicyChainProviderLoader") PolicyChainProviderLoader policyChainProviderLoader, ApiProcessorChainFactory apiProcessorChainFactory, FlowResolverFactory flowResolverFactory, RequestTimeoutConfiguration requestTimeoutConfiguration, AccessPointManager accessPointManager, EventManager eventManager) {
        return new DebugApiReactorHandlerFactory(this.applicationContext.getParent(), this.configuration, this.node, v3PolicyFactoryCreator, policyFactoryManager, debugOrganizationPolicyChainFactoryManager, organizationManager, policyChainProviderLoader, apiProcessorChainFactory, flowResolverFactory, requestTimeoutConfiguration, accessPointManager, eventManager);
    }

    @Bean
    public ReactorFactoryManager debugReactorHandlerFactoryManager(@Qualifier(value="debugReactorHandlerFactory") List<ReactorFactory> reactorFactories) {
        return new ReactorFactoryManager(reactorFactories);
    }

    @Bean
    public ReactorHandlerRegistry debugReactorHandlerRegistry(@Qualifier(value="debugReactorHandlerFactoryManager") ReactorFactoryManager reactorFactoryManager) {
        return new DefaultReactorHandlerRegistry(reactorFactoryManager);
    }
}

