/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.reactor.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.debug.DebugMetrics;
import io.gravitee.definition.model.debug.DebugStep;
import io.gravitee.definition.model.debug.PreprocessorStep;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.core.processor.AbstractProcessor;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.reactor.handler.context.DebugExecutionContext;
import io.gravitee.gateway.debug.vertx.VertxHttpServerResponseDebugDecorator;
import io.gravitee.gateway.policy.PolicyMetadata;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugEventCompletionProcessor
extends AbstractProcessor<ExecutionContext> {
    private final Logger LOGGER = LoggerFactory.getLogger(DebugEventCompletionProcessor.class);
    private final EventRepository eventRepository;
    private final ObjectMapper objectMapper;

    public DebugEventCompletionProcessor(EventRepository eventRepository, ObjectMapper objectMapper) {
        this.eventRepository = eventRepository;
        this.objectMapper = objectMapper;
    }

    public void handle(ExecutionContext context) {
        DebugExecutionContext debugContext = (DebugExecutionContext)context;
        DebugApi debugApiComponent = (DebugApi)debugContext.getComponent(Api.class);
        Vertx vertx = (Vertx)context.getComponent(Vertx.class);
        vertx.executeBlocking(promise -> {
            Event event = null;
            try {
                event = (Event)this.eventRepository.findById((Object)debugApiComponent.getEventId()).orElseThrow(TechnicalException::new);
                io.gravitee.definition.model.debug.DebugApi debugApi = this.computeDebugApiEventPayload(debugContext, debugApiComponent);
                event.setPayload(this.objectMapper.writeValueAsString((Object)debugApi));
                this.updateEvent(event, ApiDebugStatus.SUCCESS);
            }
            catch (JsonProcessingException | TechnicalException e) {
                this.LOGGER.error("Error occurs while saving debug event", e);
                this.failEvent(event);
            }
            promise.complete();
        }, result -> this.next.handle((Object)context));
    }

    private io.gravitee.definition.model.debug.DebugApi computeDebugApiEventPayload(DebugExecutionContext debugContext, DebugApi debugApiComponent) {
        io.gravitee.definition.model.debug.DebugApi debugApi = this.convert(debugApiComponent);
        PreprocessorStep preprocessorStep = this.createPreprocessorStep(debugContext);
        debugApi.setPreprocessorStep(preprocessorStep);
        debugApi.setDebugSteps(this.convert(debugContext.getDebugSteps()));
        HttpResponse response = this.createResponse(debugContext.response().headers(), debugContext.response().status(), ((VertxHttpServerResponseDebugDecorator)debugContext.response()).getBuffer());
        debugApi.setResponse(response);
        HttpResponse invokerResponse = this.createResponse(debugContext.getInvokerResponse().getHeaders(), debugContext.getInvokerResponse().getStatus(), debugContext.getInvokerResponse().getBuffer());
        debugApi.setBackendResponse(invokerResponse);
        debugApi.setMetrics(this.createMetrics(debugContext.request().metrics()));
        return debugApi;
    }

    private DebugMetrics createMetrics(Metrics requestMetrics) {
        DebugMetrics metrics = new DebugMetrics();
        if (requestMetrics != null) {
            metrics.setApiResponseTimeMs(requestMetrics.getApiResponseTimeMs());
            metrics.setProxyLatencyMs(requestMetrics.getProxyLatencyMs());
            metrics.setProxyResponseTimeMs(requestMetrics.getProxyResponseTimeMs());
        }
        return metrics;
    }

    private PreprocessorStep createPreprocessorStep(DebugExecutionContext debugContext) {
        PreprocessorStep preprocessorStep = new PreprocessorStep();
        preprocessorStep.setAttributes(debugContext.getInitialAttributes());
        preprocessorStep.setHeaders(this.convertHeaders(debugContext.getInitialHeaders()));
        return preprocessorStep;
    }

    private HttpResponse createResponse(HttpHeaders httpHeaders, int statusCode, Buffer bodyBuffer) {
        HttpResponse response = new HttpResponse();
        Map<String, List<String>> headers = this.convertHeaders(httpHeaders);
        response.setHeaders(headers);
        response.statusCode(statusCode);
        response.setBody(bodyBuffer.toString());
        return response;
    }

    Map<String, List<String>> convertHeaders(HttpHeaders headersMultimap) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (headersMultimap != null) {
            headersMultimap.forEach(e -> headers.put((String)e.getKey(), headersMultimap.getAll((CharSequence)e.getKey())));
        }
        return headers;
    }

    private void failEvent(Event debugEvent) {
        try {
            if (debugEvent != null) {
                this.updateEvent(debugEvent, ApiDebugStatus.ERROR);
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error when updating event {} with ERROR status", (Object)debugEvent.getId());
        }
    }

    private void updateEvent(Event debugEvent, ApiDebugStatus apiDebugStatus) throws TechnicalException {
        debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
        this.eventRepository.update((Object)debugEvent);
    }

    private io.gravitee.definition.model.debug.DebugApi convert(DebugApi content) {
        io.gravitee.definition.model.debug.DebugApi debugAPI = new io.gravitee.definition.model.debug.DebugApi();
        debugAPI.setName(content.getName());
        debugAPI.setId(content.getId());
        debugAPI.setDefinitionVersion(content.getDefinitionVersion());
        debugAPI.setResponse(content.getResponse());
        debugAPI.setRequest(content.getRequest());
        debugAPI.setFlowMode(content.getFlowMode());
        debugAPI.setFlows(content.getFlows());
        debugAPI.setPathMappings(content.getPathMappings());
        debugAPI.setPlans(content.getPlans());
        debugAPI.setPaths(content.getPaths());
        debugAPI.setServices(content.getServices());
        debugAPI.setProxy(content.getProxy());
        debugAPI.setProperties(content.getProperties());
        debugAPI.setResources(content.getResources());
        debugAPI.setServices(content.getServices());
        debugAPI.setResponseTemplates(content.getResponseTemplates());
        return debugAPI;
    }

    private List<DebugStep> convert(List<io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep<?>> debugSteps) {
        return debugSteps.stream().map(this::convert).collect(Collectors.toList());
    }

    private DebugStep convert(io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep<?> ds) {
        DebugStep debugStep = new DebugStep();
        debugStep.setPolicyInstanceId(ds.getPolicyInstanceId());
        debugStep.setPolicyId(ds.getPolicyId());
        debugStep.setDuration(Long.valueOf(ds.elapsedTime().toNanos()));
        debugStep.setStatus(ds.getStatus());
        debugStep.setCondition(ds.getCondition());
        debugStep.setError(ds.getError());
        debugStep.setScope(ds.getPolicyScope());
        debugStep.setStage(ds.policyMetadata().metadata().getOrDefault(PolicyMetadata.MetadataKeys.STAGE, "UNDEFINED").toString());
        HashMap result = new HashMap();
        ds.getDebugDiffContent().forEach((key, value) -> {
            if ("headers".equals(key)) {
                result.put("headers", this.convertHeaders((HttpHeaders)value));
            } else if ("bodyBuffer".equals(key)) {
                result.put("body", value.toString());
            } else {
                result.put(key, value);
            }
        });
        debugStep.setResult(result);
        return debugStep;
    }
}

