/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.trigger;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Dampening
implements Serializable {
    private final Mode mode;
    private final Integer trueEvaluations;
    private final Integer totalEvaluations;
    private final Long duration;
    private final TimeUnit timeUnit;

    @JsonCreator
    private Dampening(@JsonProperty(value="mode", required=true) Mode mode, @JsonProperty(value="trueEvaluations") Integer trueEvaluations, @JsonProperty(value="totalEvaluations") Integer totalEvaluations, @JsonProperty(value="duration") Long duration, @JsonProperty(value="timeUnit") TimeUnit timeUnit) {
        this.mode = mode;
        this.trueEvaluations = trueEvaluations;
        this.totalEvaluations = totalEvaluations;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    private Dampening(Mode mode, Integer trueEvaluations, Integer totalEvaluations, Long duration) {
        this.mode = mode;
        this.trueEvaluations = trueEvaluations;
        this.totalEvaluations = totalEvaluations;
        this.duration = duration;
        this.timeUnit = null;
    }

    public static Dampening strictCount(int trueEvaluations) {
        return new Dampening(Mode.STRICT_COUNT, trueEvaluations, trueEvaluations, null);
    }

    public static Dampening relaxedCount(int trueEvaluations, int totalEvaluations) {
        return new Dampening(Mode.RELAXED_COUNT, trueEvaluations, totalEvaluations, null);
    }

    public static Dampening strictTime(long duration) {
        return new Dampening(Mode.STRICT_TIME, null, null, duration);
    }

    public static Dampening relaxedTime(int trueEvaluations, long duration) {
        return new Dampening(Mode.STRICT_TIME, trueEvaluations, null, duration);
    }

    public Mode getMode() {
        return this.mode;
    }

    public Integer getTrueEvaluations() {
        return this.trueEvaluations;
    }

    public Integer getTotalEvaluations() {
        return this.totalEvaluations;
    }

    public Long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public static enum Mode {
        STRICT_COUNT,
        RELAXED_COUNT,
        RELAXED_TIME,
        STRICT_TIME;

    }
}

