/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition.projection;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.projection.AbstractProjection;
import io.gravitee.alert.api.condition.projection.Projection;
import io.gravitee.alert.api.event.Event;
import java.util.Objects;

public class PropertyProjection
extends AbstractProjection {
    private final String property;

    @JsonCreator
    PropertyProjection(@JsonProperty(value="property", required=true) String property) {
        super(Projection.Type.PROPERTY);
        Objects.requireNonNull(property, "Property can not be null");
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public String key(Event event) {
        if (event == null || event.properties() == null) {
            return "";
        }
        Object value = event.properties().get(this.property);
        return value != null ? value.toString() : "";
    }
}

