/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.AbstractCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.Filter;

public class ThresholdRangeCondition
extends AbstractCondition
implements Filter {
    private final String property;
    private final Operator operatorLow;
    private final Double thresholdLow;
    private final Operator operatorHigh;
    private final Double thresholdHigh;

    @JsonCreator
    private ThresholdRangeCondition(@JsonProperty(value="property", required=true) String property, @JsonProperty(value="operatorLow", required=true) Operator operatorLow, @JsonProperty(value="thresholdLow", required=true) Double thresholdLow, @JsonProperty(value="operatorHigh", required=true) Operator operatorHigh, @JsonProperty(value="thresholdHigh", required=true) Double thresholdHigh) {
        super(Condition.Type.THRESHOLD_RANGE);
        this.property = property;
        this.operatorLow = operatorLow;
        this.thresholdLow = thresholdLow;
        this.operatorHigh = operatorHigh;
        this.thresholdHigh = thresholdHigh;
    }

    public static FilterBuilder between(String property, Double thresholdLow, Double thresholdHigh) {
        return new FilterBuilder(property, Operator.INCLUSIVE, thresholdLow, Operator.INCLUSIVE, thresholdHigh);
    }

    public static FilterBuilder between(String property, Operator operatorLow, Double thresholdLow, Operator operatorHigh, Double thresholdHigh) {
        return new FilterBuilder(property, operatorLow, thresholdLow, operatorHigh, thresholdHigh);
    }

    public String getProperty() {
        return this.property;
    }

    public Operator getOperatorLow() {
        return this.operatorLow;
    }

    public Double getThresholdLow() {
        return this.thresholdLow;
    }

    public Operator getOperatorHigh() {
        return this.operatorHigh;
    }

    public Double getThresholdHigh() {
        return this.thresholdHigh;
    }

    public static class FilterBuilder {
        private final String property;
        private final Operator operatorLow;
        private final Double thresholdLow;
        private final Operator operatorHigh;
        private final Double thresholdHigh;

        FilterBuilder(String property, Operator operatorLow, Double thresholdLow, Operator operatorHigh, Double thresholdHigh) {
            this.property = property;
            this.operatorLow = operatorLow;
            this.thresholdLow = thresholdLow;
            this.operatorHigh = operatorHigh;
            this.thresholdHigh = thresholdHigh;
        }

        public ThresholdRangeCondition build() {
            return new ThresholdRangeCondition(this.property, this.operatorLow, this.thresholdLow, this.operatorHigh, this.thresholdHigh);
        }
    }

    public static enum Operator {
        INCLUSIVE,
        EXCLUSIVE;

    }
}

