/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.alert.api.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.alert.api.condition.ComparisonBasedAccumulatorCondition;
import io.gravitee.alert.api.condition.Condition;
import io.gravitee.alert.api.condition.SingleValueCondition;
import io.gravitee.alert.api.condition.projection.Projection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RateCondition
extends ComparisonBasedAccumulatorCondition {
    private final Operator operator;
    private final double threshold;
    private final int sampleSize;

    @JsonCreator
    private RateCondition(@JsonProperty(value="operator", required=true) Operator operator, @JsonProperty(value="threshold", required=true) double threshold, @JsonProperty(value="comparison", required=true) SingleValueCondition comparison, @JsonProperty(value="duration", required=true) long duration, @JsonProperty(value="timeUnit") TimeUnit timeUnit, @JsonProperty(value="sampleSize") Integer sampleSize, @JsonProperty(value="projections") List<Projection> projections) {
        super(Condition.Type.RATE, comparison, timeUnit, duration, projections);
        this.operator = operator;
        this.threshold = threshold;
        this.sampleSize = sampleSize == null ? 1 : sampleSize;
    }

    public static ComparisonBuilder of(SingleValueCondition comparison) {
        return new ComparisonBuilder(comparison);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public static class ProjectionBuilder {
        private final SingleValueCondition comparison;
        private final long duration;
        private final TimeUnit timeUnit;
        private final Operator operator;
        private final Double threshold;
        private int sampleSize;
        private List<Projection> projections;

        ProjectionBuilder(SingleValueCondition comparison, Operator operator, Double threshold, long duration, TimeUnit timeUnit) {
            this.comparison = comparison;
            this.duration = duration;
            this.timeUnit = timeUnit;
            this.operator = operator;
            this.threshold = threshold;
            this.sampleSize = 1;
        }

        public ProjectionBuilder projection(Projection projection) {
            if (this.projections == null) {
                this.projections = new ArrayList<Projection>();
            }
            this.projections.add(projection);
            return this;
        }

        public ProjectionBuilder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public RateCondition build() {
            return new RateCondition(this.operator, this.threshold, this.comparison, this.duration, this.timeUnit, this.sampleSize, this.projections);
        }
    }

    public static class DurationBuilder {
        private final SingleValueCondition comparison;
        private final long duration;
        private final TimeUnit timeUnit;

        DurationBuilder(SingleValueCondition comparison, long duration, TimeUnit timeUnit) {
            this.comparison = comparison;
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        DurationBuilder(SingleValueCondition comparison, long duration) {
            this(comparison, duration, null);
        }

        public ProjectionBuilder lowerThan(Double threshold) {
            return new ProjectionBuilder(this.comparison, Operator.LT, threshold, this.duration, this.timeUnit);
        }

        public ProjectionBuilder lowerThanOrEquals(Double threshold) {
            return new ProjectionBuilder(this.comparison, Operator.LTE, threshold, this.duration, this.timeUnit);
        }

        public ProjectionBuilder greaterThanOrEquals(Double threshold) {
            return new ProjectionBuilder(this.comparison, Operator.GTE, threshold, this.duration, this.timeUnit);
        }

        public ProjectionBuilder greaterThan(Double threshold) {
            return new ProjectionBuilder(this.comparison, Operator.GT, threshold, this.duration, this.timeUnit);
        }
    }

    public static class ComparisonBuilder {
        private final SingleValueCondition comparison;

        ComparisonBuilder(SingleValueCondition comparison) {
            this.comparison = comparison;
        }

        public DurationBuilder duration(long duration, TimeUnit timeUnit) {
            return new DurationBuilder(this.comparison, duration, timeUnit);
        }

        public DurationBuilder duration(long duration) {
            return new DurationBuilder(this.comparison, duration);
        }
    }

    public static enum Operator {
        LT,
        LTE,
        GTE,
        GT;

    }
}

