/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.utils;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import io.glimr.sdk.utils.KATSharedPreferences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;

public class KATSystemInformation {
    public static String advertId = null;
    public static boolean advertIdEnabled = false;
    public static boolean bleEnabled = false;
    public static boolean locationEnabled = false;
    public static ArrayList ips = new ArrayList();
    private static boolean forceIpOnly = false;
    public static UUID sessionId = null;
    public static String PUB_SSL_KEY = "30820122300d06092a864886f70d01010105000382010f003082010a0282010100bba3e920ec212145e553fa1831981848e799203378c713254109d787444472f4eaae47b792c3eeb6c8fa89d7d844d944994f4c72fcd1a3415d53af62125aba0dacfb7edc67048a16819e366162031780583fc4ee08976fa94e215828a3f801acf58c7d4d74e6eb8950acd9b0ae347a5a1e242c11d3c57bd607e3916435c2d22e848ff610f477dc5ad40473b361d23655237382a695c9b23c5a3fb4d6cb86e78bb12e8802dd4111e4bb6de72a1ff5d4a81db54e36d6431dbec95b5afaf1c8827444a9a62ce67dcd46d31e200d6bda23b8b042a2e87c4e3ebbe84afb6bc099966377089f4dfb594131eea36a5be5539f91c7d5ac87d59ef772fd4f29313785ddc70203010001";

    public static Boolean canDoBle(Context context) {
        String manufacturer = Build.MANUFACTURER;
        boolean ishtc = manufacturer.toLowerCase(Locale.ENGLISH).contains("htc");
        if (ishtc && Build.VERSION.SDK_INT == 23) {
            return false;
        }
        if (context == null) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            if (Build.VERSION.SDK_INT > 19 && pm.checkPermission("android.permission.BLUETOOTH", context.getPackageName()) == 0 && pm.checkPermission("android.permission.BLUETOOTH_ADMIN", context.getPackageName()) == 0 && pm.hasSystemFeature("android.hardware.bluetooth_le")) {
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)"GlimrSDK", (String)"Cannot determine if BLE active and permitted");
        }
        return false;
    }

    public static String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return KATSystemInformation.capitalize(model);
        }
        return KATSystemInformation.capitalize(manufacturer) + " " + model;
    }

    public static String getDeviceId() {
        return "android_id";
    }

    public static String getApiVersion() {
        return "2.0.0";
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static int advertIdDelay() {
        if (advertId != null) {
            return 500;
        }
        return 1000;
    }

    public static void initSettings(final Context context) {
        sessionId = UUID.randomUUID();
        new Thread(new Runnable(){

            @Override
            public void run() {
                advertId = KATSharedPreferences.getAdvertId(context);
                advertIdEnabled = KATSharedPreferences.getAdvertIdEnabled(context);
                bleEnabled = KATSystemInformation.isBluetoothEnabled(context);
                locationEnabled = KATSystemInformation.isLocationEnabled(context);
                AdvertisingIdClient.Info adInfo = null;
                try {
                    adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context.getApplicationContext());
                }
                catch (IOException iOException) {
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    // empty catch block
                }
                KATSystemInformation.getAdIdThreadFinished(adInfo, context);
            }
        }).start();
    }

    private static void getAdIdThreadFinished(AdvertisingIdClient.Info adInfo, Context context) {
        if (adInfo != null) {
            advertId = adInfo.getId();
            advertIdEnabled = !adInfo.isLimitAdTrackingEnabled();
            KATSharedPreferences.saveAdvertId(context, advertId);
            KATSharedPreferences.saveAdvertIdEnabled(context, advertIdEnabled);
        }
    }

    public static ArrayList refreshIPs(Context context) {
        return ips;
    }

    public static boolean isBluetoothEnabled(Context context) {
        PackageManager pm = context.getPackageManager();
        if (KATSystemInformation.canDoBle(context).booleanValue()) {
            BluetoothAdapter btAdapter = BluetoothAdapter.getDefaultAdapter();
            bleEnabled = btAdapter != null ? btAdapter != null && btAdapter.isEnabled() && btAdapter.getState() == 12 : false;
            return bleEnabled;
        }
        bleEnabled = false;
        return bleEnabled;
    }

    public static boolean isLocationEnabled(Context context) {
        int locationMode = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
            locationEnabled = locationMode != 0;
            return locationEnabled;
        }
        String locationProviders = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed");
        locationEnabled = !TextUtils.isEmpty((CharSequence)locationProviders);
        return locationEnabled;
    }

    public static boolean hasForcedIpOnly() {
        return forceIpOnly;
    }

    public static void setHasForcedIpOnly(boolean ipOnly) {
        forceIpOnly = ipOnly;
    }

    public static boolean hasLocationPermission(Context context) {
        if (forceIpOnly) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        return pm.checkPermission("android.permission.ACCESS_FINE_LOCATION", context.getPackageName()) == 0;
    }

    public static boolean isGenerallySupported() {
        return Build.VERSION.SDK_INT >= 17;
    }
}

