/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.network;

import io.glimr.sdk.utils.KATSystemInformation;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class KATSecurityManager
implements X509TrustManager {
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        assert (chain != null);
        if (chain == null) {
            throw new IllegalArgumentException("checkServerTrusted: X509Certificate array is null");
        }
        assert (chain.length > 0);
        if (chain.length <= 0) {
            throw new IllegalArgumentException("checkServerTrusted: X509Certificate is empty");
        }
        assert (null != authType && authType.contains("RSA"));
        if (null == authType || !authType.contains("RSA")) {
            throw new CertificateException("checkServerTrusted: AuthType is not RSA");
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
            tmf.init((KeyStore)null);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
            }
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        RSAPublicKey pubkey = (RSAPublicKey)chain[0].getPublicKey();
        String encoded = new BigInteger(1, pubkey.getEncoded()).toString(16);
        boolean expected = KATSystemInformation.PUB_SSL_KEY.equalsIgnoreCase(encoded);
        assert (expected);
        if (!expected) {
            throw new CertificateException("Glimr Host not trusted, cancel!");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

