/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.network;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.google.gson.annotations.SerializedName;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class KATRequestPayload {
    @SerializedName(value="lat")
    public Double lat;
    @SerializedName(value="lon")
    public Double lon;
    @SerializedName(value="speed")
    public Float speed;
    @SerializedName(value="course")
    public Float course;
    @SerializedName(value="collect")
    private boolean collect;
    @SerializedName(value="isRoaming")
    private boolean isRoaming;
    @SerializedName(value="batteryLevel")
    private Float batteryLevel;
    @SerializedName(value="locationState")
    private int locationState;
    @SerializedName(value="bleState")
    private int bleState;
    @SerializedName(value="notificationState")
    private int notificationState;
    @SerializedName(value="batteryState")
    private int batteryState;
    @SerializedName(value="carrierName")
    private String carrierName;
    @SerializedName(value="isoCountryCode")
    private String isoCountryCode;
    @SerializedName(value="mobileNetworkCode")
    private String mobileNetworkCode;
    @SerializedName(value="currentRadioAccessTechnology")
    private String currentRadioAccessTechnology;
    @SerializedName(value="ips")
    private ArrayList<HashMap<String, String>> ips;
    @SerializedName(value="networks")
    private ArrayList<HashMap<String, String>> networks;
    @SerializedName(value="advertIdEnabled")
    private boolean advertIdEnabled;
    @SerializedName(value="advertId")
    private String advertId;
    @SerializedName(value="api")
    private String api;
    @SerializedName(value="bundle")
    private String bundle;
    @SerializedName(value="sessionId")
    private String sessionId;
    @SerializedName(value="accuracy")
    private Float accuracy;
    @SerializedName(value="actionType")
    private int actionType;
    @SerializedName(value="beaconId")
    private String beaconId;
    @SerializedName(value="device")
    private String device;
    @SerializedName(value="locale")
    private String locale;
    @SerializedName(value="major")
    private int major;
    @SerializedName(value="minor")
    private int minor;
    @SerializedName(value="proximity")
    private int proximity;
    @SerializedName(value="regionId")
    private String regionId;
    @SerializedName(value="rssi")
    private Float rssi;
    @SerializedName(value="state")
    private int state;
    @SerializedName(value="system")
    private String system;
    @SerializedName(value="vendorId")
    private String vendorId;
    @SerializedName(value="userInfo")
    private HashMap userInfo;

    public KATRequestPayload() {
    }

    public KATRequestPayload(Context context) {
        try {
            Intent batteryIntent;
            this.advertIdEnabled = KATSystemInformation.advertIdEnabled;
            this.advertId = KATSystemInformation.advertId != null ? KATSystemInformation.advertId : KATSystemInformation.getDeviceId();
            this.api = KATSystemInformation.getApiVersion();
            this.bundle = context.getApplicationContext().getPackageName();
            this.sessionId = KATSystemInformation.sessionId.toString().toUpperCase();
            this.actionType = 9;
            this.device = KATSystemInformation.getDeviceName();
            this.locale = Locale.getDefault().toString();
            this.regionId = "";
            this.system = String.valueOf(Build.VERSION.RELEASE);
            this.vendorId = KATSystemInformation.advertId != null ? KATSystemInformation.advertId : KATSystemInformation.getDeviceId();
            this.state = 0;
            this.accuracy = Float.valueOf(0.0f);
            this.beaconId = "";
            this.major = 0;
            this.minor = 0;
            this.proximity = 0;
            this.rssi = Float.valueOf(0.0f);
            this.notificationState = -1;
            this.lat = 0.0;
            this.lon = 0.0;
            this.speed = Float.valueOf(0.0f);
            this.course = Float.valueOf(0.0f);
            this.collect = false;
            this.bleState = 0;
            this.locationState = 0;
            this.bleState = KATSystemInformation.bleEnabled ? 1 : 0;
            this.locationState = KATSystemInformation.locationEnabled ? 1 : 0;
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            this.carrierName = manager.getSimOperatorName() != null ? manager.getSimOperatorName() : "";
            this.isoCountryCode = manager.getSimOperator() != null ? manager.getSimOperator() : "";
            this.currentRadioAccessTechnology = manager.getNetworkType() + "";
            this.mobileNetworkCode = manager.getNetworkOperator() != null ? manager.getNetworkOperator() : "";
            this.isRoaming = manager.isNetworkRoaming();
            this.ips = KATSystemInformation.ips;
            this.networks = new ArrayList();
            int premission_wifi_service = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
            if (premission_wifi_service == 0) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                HashMap<String, String> network = new HashMap<String, String>();
                network.put("ssid", wifiInfo.getSSID());
                network.put("bssid", wifiInfo.getBSSID());
                network.put("networkId", "" + wifiInfo.getNetworkId());
                network.put("ip", "" + wifiInfo.getIpAddress());
                network.put("mac", wifiInfo.getMacAddress());
                this.networks.add(network);
            }
            int plugged = (batteryIntent = context.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null ? batteryIntent.getIntExtra("plugged", -1) : -1;
            int rawlevel = batteryIntent != null ? batteryIntent.getIntExtra("level", -1) : -1;
            double scale = batteryIntent != null ? (double)batteryIntent.getIntExtra("scale", -1) : -1.0;
            float level = -1.0f;
            if (rawlevel >= 0 && scale > 0.0) {
                level = (float)rawlevel / (float)scale;
            }
            this.batteryLevel = Float.valueOf(level);
            this.batteryState = plugged;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public boolean getIsRoaming() {
        return this.isRoaming;
    }

    public Float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = Float.valueOf(speed);
    }

    public Float getCourse() {
        return this.course;
    }

    public void setCourse(float course) {
        this.course = Float.valueOf(course);
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public boolean getCollect() {
        return this.collect;
    }

    public void setCollect(boolean collect) {
        this.collect = collect;
    }

    public boolean getAdvertIdEnabled() {
        return this.advertIdEnabled;
    }

    public int getLocationState() {
        return this.locationState;
    }

    public void setLocationState(int locationState) {
        this.locationState = locationState;
    }

    public int getBleState() {
        return this.bleState;
    }

    public void setBleState(int bleState) {
        this.bleState = bleState;
    }

    public int getNotificationState() {
        return this.notificationState;
    }

    public void setNotificationState(int notificationState) {
        this.notificationState = notificationState;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getAdvertId() {
        return this.advertId;
    }

    public void setAdvertId(String advertId) {
        this.advertId = advertId;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public Float getRssi() {
        return this.rssi;
    }

    public void setRssi(Float rssi) {
        this.rssi = rssi;
    }

    public void setRssi(float rssi) {
        this.rssi = Float.valueOf(rssi);
    }

    public int getProximity() {
        return this.proximity;
    }

    public void setProximity(int proximity) {
        this.proximity = proximity;
    }

    public Float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Float accuracy) {
        this.accuracy = accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = Float.valueOf(accuracy);
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getBeaconId() {
        return this.beaconId;
    }

    public void setBeaconId(String beaconId) {
        this.beaconId = beaconId;
    }

    public HashMap getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(HashMap userInfo) {
        this.userInfo = userInfo;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public void setIsoCountryCode(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
    }

    public String getMobileNetworkCode() {
        return this.mobileNetworkCode;
    }

    public void setMobileNetworkCode(String mobileNetworkCode) {
        this.mobileNetworkCode = mobileNetworkCode;
    }

    public String getCurrentRadioAccessTechnology() {
        return this.currentRadioAccessTechnology;
    }

    public void setCurrentRadioAccessTechnology(String currentRadioAccessTechnology) {
        this.currentRadioAccessTechnology = currentRadioAccessTechnology;
    }

    public ArrayList<HashMap<String, String>> getNetworks() {
        return this.networks;
    }

    public void setNetworks(ArrayList<HashMap<String, String>> networks) {
        this.networks = networks;
    }

    public boolean isAdvertIdEnabled() {
        return this.advertIdEnabled;
    }

    public void setAdvertIdEnabled(boolean advertIdEnabled) {
        this.advertIdEnabled = advertIdEnabled;
    }

    public ArrayList<HashMap<String, String>> getIps() {
        return this.ips;
    }

    public void setIps(ArrayList<HashMap<String, String>> ips) {
        this.ips = ips;
    }
}

