/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.geofence;

import android.content.Context;
import android.content.SharedPreferences;
import io.glimr.sdk.geofence.KATGeofence;

public class KATGeofenceStore {
    private static final String SHARED_PREFERENCE_NAME = "io.glimr.sdk.geofencestore";
    private final SharedPreferences mPrefs;

    public KATGeofenceStore(Context context) {
        this.mPrefs = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
    }

    public void setGeofence(String id, KATGeofence geofence) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putFloat(this.getGeofenceFieldKey(id, "io.glimr.sdk.geofence.KEY_LATITUDE"), (float)geofence.getLatitude());
        editor.putFloat(this.getGeofenceFieldKey(id, "io.glimr.sdk.geofence.KEY_LONGITUDE"), (float)geofence.getLongitude());
        editor.putFloat(this.getGeofenceFieldKey(id, "io.glimr.sdk.geofence.KEY_RADIUS"), geofence.getRadius());
        editor.putInt(this.getGeofenceFieldKey(id, "io.glimr.sdk.geofence.KEY_TRANSITION_TYPE"), geofence.getTransitionType());
        editor.apply();
    }

    private String getGeofenceFieldKey(String id, String fieldName) {
        return "io.glimr.sdk.geofence.KEY" + id + "_" + fieldName;
    }
}

