/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.geofence;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationServices;
import com.google.gson.internal.LinkedTreeMap;
import io.glimr.sdk.geofence.KATGeofence;
import io.glimr.sdk.geofence.KATGeofenceIntentService;
import io.glimr.sdk.geofence.KATGeofenceStore;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.ArrayList;
import java.util.List;

public class KATGeofenceManager
implements GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks {
    public static final String TAG = "com.glimr.sdk";
    List<Geofence> mGeofenceList;
    private KATGeofenceStore mGeofenceStorage;
    private PendingIntent mGeofenceRequestIntent;
    private GoogleApiClient mApiClient;
    private Context context;

    public KATGeofenceManager(Context context) {
        this.context = context;
        if (!this.isGooglePlayServicesAvailable()) {
            Log.i((String)"GlimrSDK", (String)"Google Play services unavailable.");
            return;
        }
        this.mApiClient = new GoogleApiClient.Builder(this.getApplicationContext()).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.mGeofenceStorage = new KATGeofenceStore(this.getApplicationContext());
    }

    public void updateGeofences(ArrayList<LinkedTreeMap> circulars) {
        this.mGeofenceList = new ArrayList<Geofence>();
        if (circulars.size() > 0) {
            try {
                for (LinkedTreeMap map : circulars) {
                    KATGeofence mUIGeofence1 = new KATGeofence((String)map.get((Object)"identifier"), (Double)map.get((Object)"latitude"), (Double)map.get((Object)"longitude"), new Float((Double)map.get((Object)"radius")).floatValue(), 3);
                    this.mGeofenceStorage.setGeofence((String)map.get((Object)"identifier"), mUIGeofence1);
                    this.mGeofenceList.add(mUIGeofence1.toGeofence());
                }
                this.mApiClient.connect();
            }
            catch (Exception e) {
                Log.e((String)"GlimrSDK", (String)"Exception while parsing regions.");
            }
        }
    }

    private Context getApplicationContext() {
        return this.context.getApplicationContext();
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            Log.e((String)"GlimrSDK", (String)"Exception while resolving connection error.");
        } else {
            int errorCode = connectionResult.getErrorCode();
            Log.e((String)"GlimrSDK", (String)("Connection to Google Play services failed with error code " + errorCode));
        }
    }

    public void onConnected(Bundle connectionHint) {
        try {
            if (KATSystemInformation.hasLocationPermission(this.context)) {
                this.mGeofenceRequestIntent = this.getGeofenceTransitionPendingIntent();
                LocationServices.GeofencingApi.removeGeofences(this.mApiClient, this.mGeofenceRequestIntent);
                LocationServices.GeofencingApi.addGeofences(this.mApiClient, this.mGeofenceList, this.mGeofenceRequestIntent);
            }
        }
        catch (Exception e) {
            Log.e((String)"GlimrSDK", (String)"Exception while setting up geofences.");
        }
    }

    public void onConnectionSuspended(int i) {
    }

    private boolean isGooglePlayServicesAvailable() {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.context);
        if (0 == resultCode) {
            return true;
        }
        Log.e((String)"GlimrSDK", (String)"Google Play services is unavailable.");
        return false;
    }

    private PendingIntent getGeofenceTransitionPendingIntent() {
        Intent intent = new Intent(this.getApplicationContext(), KATGeofenceIntentService.class);
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
    }
}

