/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.service;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;
import io.glimr.sdk.beacon.Region;
import io.glimr.sdk.beacon.service.Callback;
import io.glimr.sdk.beacon.service.MonitorState;
import io.glimr.sdk.beacon.service.MonitoringData;
import io.glimr.sdk.beacon.service.RangeState;
import io.glimr.sdk.beacon.service.RangingData;
import io.glimr.sdk.beacon.service.StartRMData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IBeaconService
extends Service {
    public static final String TAG = "IBeaconService";
    public static final int MSG_START_RANGING = 2;
    public static final int MSG_STOP_RANGING = 3;
    public static final int MSG_START_MONITORING = 4;
    public static final int MSG_STOP_MONITORING = 5;
    public static final int MSG_SET_SCAN_PERIODS = 6;
    public static final int MSG_START_SCANNING = 7;
    public static final int MSG_STOP_SCANNING = 8;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));
    private Map<Region, RangeState> rangedRegionState = new HashMap<Region, RangeState>();
    private Map<Region, MonitorState> monitoredRegionState = new HashMap<Region, MonitorState>();
    private BluetoothAdapter bluetoothAdapter;
    private boolean scanning;
    private boolean scanningPaused;
    private Date lastIBeaconDetectionTime = new Date();
    private HashSet<IBeacon> trackedBeacons;
    private Handler handler = new Handler();
    private int bindCount = 0;
    private List<IBeacon> simulatedScanData = null;
    private int ongoing_notification_id = 1;
    private long lastScanEndTime = 0L;
    private BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            new ScanProcessor().execute(new ScanData[]{new ScanData(device, rssi, scanRecord)});
        }
    };

    public IBinder onBind(Intent intent) {
        ++this.bindCount;
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        --this.bindCount;
        return false;
    }

    public void onCreate() {
        this.getBluetoothAdapter();
    }

    public void onDestroy() {
        if (IBeaconManager.LOG_DEBUG) {
            Log.e((String)TAG, (String)"#Beacon onDestory called.  stopping scanning");
        }
        if (this.bluetoothAdapter != null && this.scanning && this.leScanCallback != null && this.bluetoothAdapter.getState() == 12) {
            this.bluetoothAdapter.stopLeScan(this.leScanCallback);
            this.lastScanEndTime = new Date().getTime();
        }
    }

    private boolean isInBackground() {
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("bound client count:" + this.bindCount));
        }
        return this.bindCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRangingBeaconsInRegion(Region region, Callback callback) {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            if (this.rangedRegionState.containsKey(region)) {
                if (IBeaconManager.LOG_DEBUG) {
                    Log.i((String)TAG, (String)"Already ranging that region -- will replace existing region.");
                }
                this.rangedRegionState.remove(region);
            }
            this.rangedRegionState.put(region, new RangeState(callback));
        }
        if (!this.scanning) {
            this.scanLeDevice(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRangingBeaconsInRegion(Region region) {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            this.rangedRegionState.remove(region);
        }
        if (this.scanning && this.rangedRegionState.size() == 0 && this.monitoredRegionState.size() == 0) {
            this.scanLeDevice(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoringBeaconsInRegion(Region region, Callback callback) {
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"startMonitoring called");
        }
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            if (this.monitoredRegionState.containsKey(region)) {
                if (IBeaconManager.LOG_DEBUG) {
                    Log.i((String)TAG, (String)"Already monitoring that region -- will replace existing region monitor.");
                }
                this.monitoredRegionState.remove(region);
            }
            this.monitoredRegionState.put(region, new MonitorState(callback));
        }
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("Currently monitoring " + this.monitoredRegionState.size() + " regions."));
        }
        if (!this.scanning) {
            this.scanLeDevice(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringBeaconsInRegion(Region region) {
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"stopMonitoring called");
        }
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            this.monitoredRegionState.remove(region);
        }
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("Currently monitoring " + this.monitoredRegionState.size() + " regions."));
        }
        if (this.scanning && this.rangedRegionState.size() == 0 && this.monitoredRegionState.size() == 0) {
            this.scanLeDevice(false);
        }
    }

    private void scanLeDevice(Boolean enable) {
        BluetoothAdapter adapter = this.getBluetoothAdapter();
        if (adapter == null || this.leScanCallback == null || adapter.getState() != 12) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.e((String)TAG, (String)"No bluetooth adapter.  iBeaconService cannot scan.");
            }
            if (this.simulatedScanData == null) {
                Log.w((String)TAG, (String)"exiting");
                return;
            }
            if (IBeaconManager.LOG_DEBUG) {
                Log.w((String)TAG, (String)"proceeding with simulated scan data");
            }
        }
        if (enable.booleanValue()) {
            block16: {
                this.trackedBeacons = new HashSet();
                if (!this.scanning || this.scanningPaused) {
                    this.scanning = true;
                    this.scanningPaused = false;
                    try {
                        if (adapter == null || this.leScanCallback == null) break block16;
                        if (adapter.isEnabled() && adapter.getState() == 12) {
                            adapter.startLeScan(this.leScanCallback);
                        } else if (IBeaconManager.LOG_DEBUG) {
                            Log.w((String)TAG, (String)"Bluetooth is disabled.  Cannot scan for iBeacons.");
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"TAG", (String)"Exception starting bluetooth scan.  Perhaps bluetooth is disabled or unavailable?");
                    }
                } else if (IBeaconManager.LOG_DEBUG) {
                    Log.d((String)TAG, (String)"We are already scanning");
                }
            }
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)"Scan started");
            }
        } else {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)"Scan stopped");
            }
            this.finishScanCycle();
        }
    }

    private void scheduleScanStop() {
        this.finishScanCycle();
    }

    private void finishScanCycle() {
        this.processExpiredMonitors();
        if (this.scanning) {
            if (!this.anyRangingOrMonitoringRegionsActive()) {
                if (IBeaconManager.LOG_DEBUG) {
                    Log.d((String)TAG, (String)"Not starting scan because no monitoring or ranging regions are defined.");
                }
            } else {
                this.processRangeData();
                BluetoothAdapter adapter = this.getBluetoothAdapter();
                if (adapter != null && this.leScanCallback != null && adapter.getState() == 12) {
                    try {
                        if (adapter.isEnabled()) {
                            this.scanning = false;
                            adapter.stopLeScan(this.leScanCallback);
                            this.lastScanEndTime = new Date().getTime();
                        } else if (IBeaconManager.LOG_DEBUG) {
                            Log.w((String)TAG, (String)"Bluetooth is disabled.  Cannot scan for iBeacons.");
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Can't finish cycle, object likely to have vanished");
                    }
                }
                this.scanningPaused = true;
            }
        }
    }

    private void processRangeData() {
        for (Region region : this.rangedRegionState.keySet()) {
            RangeState rangeState = this.rangedRegionState.get(region);
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("Calling ranging callback with " + rangeState.getIBeacons().size() + " iBeacons"));
            }
            rangeState.getCallback().call((Context)this, "rangingData", new RangingData(rangeState.getIBeacons(), region));
            rangeState.clearIBeacons();
        }
    }

    private void processExpiredMonitors() {
        for (Region region : this.monitoredRegionState.keySet()) {
            MonitorState state = this.monitoredRegionState.get(region);
            if (!state.isNewlyOutside()) continue;
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("found a monitor that expired: " + region));
            }
            state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIBeaconFromScan(IBeacon iBeacon) {
        this.lastIBeaconDetectionTime = new Date();
        this.trackedBeacons.add(iBeacon);
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)("iBeacon detected :" + iBeacon.getProximityUuid() + " " + iBeacon.getMajor() + " " + iBeacon.getMinor() + " accuracy: " + iBeacon.getAccuracy() + " proximity: " + iBeacon.getProximity()));
        }
        List<Region> matchedRegions = null;
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            matchedRegions = this.matchingRegions(iBeacon, this.monitoredRegionState.keySet());
        }
        for (Region region : matchedRegions) {
            MonitorState state = this.monitoredRegionState.get(region);
            if (!state.markInside()) continue;
            state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
        }
        if (IBeaconManager.LOG_DEBUG) {
            Log.d((String)TAG, (String)"looking for ranging region matches for this ibeacon");
        }
        Map<Region, RangeState> map2 = this.rangedRegionState;
        synchronized (map2) {
            matchedRegions = this.matchingRegions(iBeacon, this.rangedRegionState.keySet());
        }
        for (Region region : matchedRegions) {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("matches ranging region: " + region));
            }
            RangeState rangeState = this.rangedRegionState.get(region);
            rangeState.addIBeacon(iBeacon);
        }
    }

    private List<Region> matchingRegions(IBeacon iBeacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region.matchesIBeacon(iBeacon)) {
                matched.add(region);
                continue;
            }
            if (!IBeaconManager.LOG_DEBUG) continue;
            Log.d((String)TAG, (String)("This region does not match: " + region));
        }
        return matched;
    }

    private boolean anyRangingOrMonitoringRegionsActive() {
        return this.rangedRegionState.size() + this.monitoredRegionState.size() > 0;
    }

    private BluetoothAdapter getBluetoothAdapter() {
        if (this.bluetoothAdapter == null) {
            BluetoothManager bluetoothManager = (BluetoothManager)this.getApplicationContext().getSystemService("bluetooth");
            this.bluetoothAdapter = bluetoothManager.getAdapter();
        }
        return this.bluetoothAdapter;
    }

    private class ScanProcessor
    extends AsyncTask<ScanData, Void, Void> {
        private ScanProcessor() {
        }

        protected Void doInBackground(ScanData ... params) {
            ScanData scanData = params[0];
            IBeacon iBeacon = IBeacon.fromScanData(scanData.scanRecord, scanData.rssi);
            if (iBeacon != null) {
                IBeaconService.this.processIBeaconFromScan(iBeacon);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    private class ScanData {
        public BluetoothDevice device;
        public int rssi;
        public byte[] scanRecord;

        public ScanData(BluetoothDevice device, int rssi, byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }

    public class IBeaconBinder
    extends Binder {
        public IBeaconService getService() {
            if (IBeaconManager.LOG_DEBUG) {
                Log.i((String)IBeaconService.TAG, (String)"getService of IBeaconBinder called");
            }
            return IBeaconService.this;
        }
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<IBeaconService> mService;

        IncomingHandler(IBeaconService service) {
            this.mService = new WeakReference<IBeaconService>(service);
        }

        public void handleMessage(Message msg) {
            IBeaconService service = (IBeaconService)((Object)this.mService.get());
            StartRMData startRMData = (StartRMData)msg.obj;
            if (service != null) {
                switch (msg.what) {
                    case 2: {
                        service.startRangingBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        break;
                    }
                    case 3: {
                        service.stopRangingBeaconsInRegion(startRMData.getRegionData());
                        break;
                    }
                    case 4: {
                        service.startMonitoringBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        break;
                    }
                    case 5: {
                        service.stopMonitoringBeaconsInRegion(startRMData.getRegionData());
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        service.scanLeDevice(true);
                        break;
                    }
                    case 8: {
                        service.scanLeDevice(false);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        }
    }
}

