/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.service;

import android.os.Parcel;
import android.os.Parcelable;
import io.glimr.sdk.beacon.IBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IBeaconData
extends IBeacon
implements Parcelable {
    public static final Parcelable.Creator<IBeaconData> CREATOR = new Parcelable.Creator<IBeaconData>(){

        public IBeaconData createFromParcel(Parcel in) {
            return new IBeaconData(in);
        }

        public IBeaconData[] newArray(int size) {
            return new IBeaconData[size];
        }
    };

    public IBeaconData(IBeacon iBeacon) {
        super(iBeacon);
    }

    private IBeaconData(Parcel in) {
        this.major = in.readInt();
        this.minor = in.readInt();
        this.proximityUuid = in.readString();
        this.proximity = in.readInt();
        this.accuracy = in.readDouble();
        this.rssi = in.readInt();
        this.txPower = in.readInt();
    }

    public static Collection<IBeaconData> fromIBeacons(Collection<IBeacon> iBeacons) {
        ArrayList<IBeaconData> iBeaconDatas = new ArrayList<IBeaconData>();
        Iterator<IBeacon> iBeaconIterator = iBeacons.iterator();
        while (iBeaconIterator.hasNext()) {
            iBeaconDatas.add(new IBeaconData(iBeaconIterator.next()));
        }
        return iBeaconDatas;
    }

    public static Collection<IBeacon> fromIBeaconDatas(Collection<IBeaconData> iBeaconDatas) {
        ArrayList<IBeacon> iBeacons = new ArrayList<IBeacon>();
        if (iBeaconDatas != null) {
            Iterator<IBeaconData> iBeaconIterator = iBeaconDatas.iterator();
            while (iBeaconIterator.hasNext()) {
                iBeacons.add(iBeaconIterator.next());
            }
        }
        return iBeacons;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.major);
        out.writeInt(this.minor);
        out.writeString(this.proximityUuid);
        out.writeInt(this.getProximity());
        out.writeDouble(this.getAccuracy());
        out.writeInt(this.rssi);
        out.writeInt(this.txPower);
    }
}

