/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.client;

import android.util.Log;
import io.glimr.sdk.beacon.IBeacon;
import io.glimr.sdk.beacon.IBeaconManager;
import io.glimr.sdk.beacon.client.RangedIBeacon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RangingTracker {
    private static String TAG = "RangingTracker";
    private Map<IBeacon, RangedIBeacon> rangedIBeacons = new HashMap<IBeacon, RangedIBeacon>();

    public void addIBeacon(IBeacon iBeacon) {
        if (this.rangedIBeacons.containsKey(iBeacon)) {
            RangedIBeacon rangedIBeacon = this.rangedIBeacons.get(iBeacon);
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("adding " + iBeacon.getProximityUuid() + " to existing range for: " + rangedIBeacon.getProximityUuid()));
            }
            rangedIBeacon.addRangeMeasurement(iBeacon.getRssi());
        } else {
            if (IBeaconManager.LOG_DEBUG) {
                Log.d((String)TAG, (String)("adding " + iBeacon.getProximityUuid() + " to new rangedIBeacon"));
            }
            this.rangedIBeacons.put(iBeacon, new RangedIBeacon(iBeacon));
        }
    }

    public synchronized Collection<IBeacon> getIBeacons() {
        ArrayList<IBeacon> iBeacons = new ArrayList<IBeacon>();
        for (RangedIBeacon rangedIBeacon : this.rangedIBeacons.values()) {
            if (rangedIBeacon.allMeasurementsExpired()) continue;
            iBeacons.add(rangedIBeacon);
        }
        return iBeacons;
    }
}

