package io.glimr.sdk.engine;


import java.util.ArrayList;
import java.util.HashMap;

public interface KATEvent {
    /**
     * If data is set to return, it will return here
     *
     * @param usertags user key/value map for the current device
     */
    void availableAudiencesUpdated(HashMap<String, ArrayList<String>> usertags);


    /**
     * If the requests fail, this interface method will be called
     *
     * @param responseCode HTTP response code
     * @param errorMessage HTTP response error message
     */
    void audienceUpdateError(int responseCode, String errorMessage);
}
