/**
 * Radius Networks, Inc.
 * http://www.radiusnetworks.com
 *
 * @author David G. Young
 * <p/>
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.glimr.sdk.beacon.service;

import android.os.Parcel;
import android.os.Parcelable;

import io.glimr.sdk.beacon.Region;

public class RegionData extends Region implements Parcelable {
    public static final Creator<RegionData> CREATOR
            = new Creator<RegionData>() {
        public RegionData createFromParcel(Parcel in) {
            return new RegionData(in);
        }

        public RegionData[] newArray(int size) {
            return new RegionData[size];
        }
    };

    public RegionData(String uniqueId, String proximityUuid, Integer major,
                      Integer minor) {
        super(uniqueId, proximityUuid, major, minor);
    }

    public RegionData(Region region) {
        super(region);
    }

    private RegionData(Parcel in) {
        major = in.readInt();
        if (major == -1) {
            major = null;
        }
        minor = in.readInt();
        if (minor == -1) {
            minor = null;
        }
        proximityUuid = in.readString();
        uniqueId = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(major == null ? -1 : major);
        out.writeInt(minor == null ? -1 : minor);
        out.writeString(proximityUuid);
        out.writeString(uniqueId);
    }

}
