/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.network;

import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import io.glimr.sdk.network.KATSecurityManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public class KATSSLFactory
extends SSLSocketFactory {
    static final HostnameVerifier hostnameVerifier = new StrictHostnameVerifier();
    SSLContext sslContext = SSLContext.getInstance(Build.VERSION.SDK_INT >= 16 ? "TLSv1.2" : "TLS");

    public KATSSLFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(truststore);
        TrustManager[] tm = new TrustManager[]{new KATSecurityManager()};
        this.sslContext.init(null, tm, null);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        if (autoClose) {
            socket.close();
        }
        TrustManager[] tm = new TrustManager[]{new KATSecurityManager()};
        SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
        SSLSocket ssl = (SSLSocket)sslSocketFactory.createSocket(InetAddress.getByName(host), port);
        ssl.setEnabledProtocols(ssl.getSupportedProtocols());
        if (Build.VERSION.SDK_INT >= 17) {
            sslSocketFactory.setHostname((Socket)ssl, host);
        } else {
            try {
                socket.getClass().getMethod("setHostname", String.class).invoke((Object)socket, host);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SSLSession session = ssl.getSession();
        if (!hostnameVerifier.verify(host, session)) {
            throw new SSLPeerUnverifiedException("Cannot verify hostname: " + host);
        }
        return ssl;
    }

    public Socket createSocket() throws IOException {
        return this.sslContext.getSocketFactory().createSocket();
    }
}

