/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.network;

import android.os.AsyncTask;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.glimr.sdk.network.KATRequest;
import io.glimr.sdk.network.KATRequestDone;
import io.glimr.sdk.network.KATResponse;
import io.glimr.sdk.network.KATSSLFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class KATPostReqAsync
extends AsyncTask<KATRequest, Void, HashMap<Integer, Object>> {
    private final KATRequestDone requestDone;
    private final String mApiToken;

    public KATPostReqAsync(String apiToken, KATRequestDone requestDone) {
        this.requestDone = requestDone;
        this.mApiToken = apiToken;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    public HttpClient getNewHttpClient() {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            KATSSLFactory sf = new KATSSLFactory(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)sf, 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            return new DefaultHttpClient();
        }
    }

    protected HashMap<Integer, Object> doInBackground(KATRequest ... params) {
        HashMap<Integer, Object> responseMap = new HashMap<Integer, Object>();
        KATRequest request = params[0];
        try {
            HttpClient client = this.getNewHttpClient();
            HttpPost post = new HttpPost(request.url);
            if (request.payloadObject != null) {
                Gson gson = new Gson();
                String message = gson.toJson(request.payloadObject);
                StringEntity stringEntity = new StringEntity(message, "UTF-8");
                post.setEntity((HttpEntity)stringEntity);
            }
            post.setHeader("Content-type", "application/json");
            post.setHeader("API_TOKEN", this.mApiToken);
            HttpResponse response = client.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            if (statusLine.getStatusCode() == 200) {
                Gson gsonResponse = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntegerTypeAdapter()).create();
                if (request.expectedClass == null) {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map collection = (Map)gsonResponse.fromJson((Reader)reader, type);
                    KATResponse responseObject = new KATResponse(collection);
                    responseMap.put(statusLine.getStatusCode(), responseObject);
                } else {
                    Object finalResult = gsonResponse.fromJson((Reader)reader, request.expectedClass);
                    KATResponse responseObject = new KATResponse(finalResult);
                    responseMap.put(statusLine.getStatusCode(), responseObject);
                }
            } else {
                Log.d((String)"GlimrSDK", (String)("#Server responded with status code: " + statusLine.getStatusCode()));
                responseMap.put(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
        }
        catch (Exception ex) {
            Log.e((String)"GlimrSDK", (String)("#Failed to send HTTP POST request due to: " + ex.getMessage()));
            responseMap.put(1, ex.getMessage());
        }
        return responseMap;
    }

    protected void onPostExecute(HashMap<Integer, Object> result) {
        super.onPostExecute(result);
        if (result.containsKey(200) && result.get(200) != null && result.get(200) instanceof KATResponse) {
            KATResponse response = (KATResponse)result.get(200);
            if (this.requestDone != null) {
                this.requestDone.KATRequestSuccess(response);
            }
        } else {
            Set<Integer> integerSet = result.keySet();
            Iterator<Integer> i = integerSet.iterator();
            if (i.hasNext()) {
                Integer responseCode = i.next();
                String stringResult = (String)result.get(responseCode);
                Log.w((String)"GlimrSDK", (String)("#responseFailed, with code " + responseCode + " and result " + stringResult));
                if (this.requestDone != null) {
                    this.requestDone.KATRequestFailed(responseCode, stringResult);
                }
                return;
            }
        }
    }

    public class IntegerTypeAdapter
    extends TypeAdapter<Integer> {
        public void write(JsonWriter writer, Integer value) throws IOException {
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.value((Number)value);
        }

        public Integer read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            String stringValue = reader.nextString();
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }
}

