/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.engine;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationServices;
import com.google.gson.internal.LinkedTreeMap;
import io.glimr.sdk.audience.KATAudienceManager;
import io.glimr.sdk.beacon.KATBeaconManager;
import io.glimr.sdk.beacon.service.KATBeaconReceiver;
import io.glimr.sdk.engine.KATEvent;
import io.glimr.sdk.geofence.KATGeofenceManager;
import io.glimr.sdk.network.KATEndPoints;
import io.glimr.sdk.network.KATPostReqAsync;
import io.glimr.sdk.network.KATRequest;
import io.glimr.sdk.network.KATRequestDone;
import io.glimr.sdk.network.KATRequestPayload;
import io.glimr.sdk.network.KATResponse;
import io.glimr.sdk.utils.KATSharedPreferences;
import io.glimr.sdk.utils.KATSystemInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class KATManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static boolean disableCaching;
    private static KATGeofenceManager mKatGeofenceManager;
    private static KATAudienceManager mKatAudienceManager;
    private static GoogleApiClient mGoogleApiClient;
    private static Location mLastLocation;
    private static Location mMockLocation;
    private boolean geotagCallRequested;
    private KATEvent mCallbackContext;
    private boolean monitoringCallRequested;
    private Context context;
    private KATBeaconManager mKatBeaconManager;
    private String apiToken;
    private static KATManager instance;

    private KATManager() {
    }

    public static synchronized KATManager getInstance() {
        if (instance == null) {
            instance = new KATManager();
        }
        return instance;
    }

    private KATManager(Context context, String apiToken, int scanInterval, boolean forceIpOnly) {
        KATManager m = KATManager.getInstance();
        m.init(context, apiToken, scanInterval, forceIpOnly);
        Log.e((String)"GlimrSDK Error", (String)"Please use getInstance() and configure() instead");
    }

    public void init(Context context, String apiToken) {
        this.init(context, apiToken, 90, false, 90);
    }

    public void init(Context context, String apiToken, int scanInterval) {
        this.init(context, apiToken, scanInterval, false, 90);
    }

    public void init(Context context, String apiToken, int scanInterval, boolean forceIpOnly) {
        this.init(context, apiToken, scanInterval, forceIpOnly, 90);
    }

    public void init(final Context context, final String apiToken, final int scanInterval, boolean forceIpOnly, int tagCacheExpireSeconds) {
        this.context = context;
        this.apiToken = apiToken;
        this.setForceIpOnly(forceIpOnly);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                KATSharedPreferences.saveEntry(context, apiToken);
                KATSharedPreferences.saveScanInterval(context, scanInterval);
                KATSharedPreferences.getSharedPreferencesUrls(context);
            }
        });
        thread.start();
        try {
            this.mKatBeaconManager = KATBeaconManager.getInstance(context);
            this.mKatBeaconManager.setApiToken(apiToken);
            mKatAudienceManager = new KATAudienceManager(context, apiToken, tagCacheExpireSeconds);
            mKatGeofenceManager = new KATGeofenceManager(context);
        }
        catch (Exception e) {
            Log.e((String)"GlimrSDK Error", (String)e.getMessage());
        }
        KATSystemInformation.initSettings(context);
    }

    public void setAudiencesAndGeotagsCallback(KATEvent callbackContext) {
        this.mCallbackContext = callbackContext;
    }

    public static ArrayList<String> mapToArrayList(HashMap<String, ArrayList<String>> kv) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : kv.entrySet()) {
            result.addAll((Collection<String>)entry.getValue());
        }
        return result;
    }

    public static String map2QueryString(HashMap<String, ArrayList<String>> kv) {
        ArrayList<String> parts = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : kv.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> values = entry.getValue();
            String part = "";
            for (String value : values) {
                part = key + "=" + Uri.encode((String)value);
            }
            if (part.equals("")) continue;
            parts.add(part);
        }
        return TextUtils.join((CharSequence)"&", parts);
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    protected synchronized void buildGoogleApiClient() {
        this.mKatBeaconManager.isApplicationOpen = true;
        if (!KATSystemInformation.hasLocationPermission(this.context)) {
            return;
        }
        if (mGoogleApiClient == null) {
            mGoogleApiClient = new GoogleApiClient.Builder(this.context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        if (mGoogleApiClient.isConnected()) {
            if (mGoogleApiClient.hasConnectedApi(LocationServices.API)) {
                mLastLocation = this.updatedLocation();
            } else {
                mGoogleApiClient.reconnect();
            }
        } else {
            mGoogleApiClient.connect();
        }
    }

    private void initMonitoring(ArrayList<LinkedTreeMap> regionArray) {
        if (Build.VERSION.SDK_INT < 18) {
            return;
        }
        ArrayList<String> beacons = new ArrayList<String>();
        ArrayList<LinkedTreeMap> circular = new ArrayList<LinkedTreeMap>();
        for (LinkedTreeMap region : regionArray) {
            if ((Double)region.get((Object)"type") == 0.0) {
                beacons.add((String)region.get((Object)"identifier"));
                continue;
            }
            circular.add(region);
        }
        if (KATSystemInformation.canDoBle(this.context).booleanValue()) {
            if (beacons.size() > 0) {
                KATBeaconReceiver beaconAlarm = new KATBeaconReceiver();
                beaconAlarm.schedule(this.context);
            }
        } else {
            Log.d((String)"GlimrSDK", (String)"Can't do BLE tracking, needs > 4.4 + permissions");
        }
        if (KATSystemInformation.hasLocationPermission(this.context)) {
            mKatGeofenceManager.updateGeofences(circular);
        }
    }

    private void updateConfig() {
        ArrayList config;
        final Date now = new Date();
        long diffInMs = now.getTime() - KATSharedPreferences.getLastConfigUpdateDate(this.context).getTime();
        if (disableCaching) {
            Log.d((String)"GlimrSDK", (String)"#Caching disabled, please enable for production - Glimr");
        }
        if (!disableCaching && diffInMs > 0L && TimeUnit.MILLISECONDS.toSeconds(diffInMs) < 900L && (config = KATSharedPreferences.getConfigResponse(this.context)) != null) {
            this.initMonitoring(config);
            return;
        }
        try {
            KATRequestPayload requestPayload = new KATRequestPayload(this.context);
            if (mLastLocation != null) {
                requestPayload.lat = mLastLocation.getLatitude();
                requestPayload.lon = mLastLocation.getLongitude();
                requestPayload.course = Float.valueOf(mLastLocation.getBearing());
                requestPayload.speed = Float.valueOf(mLastLocation.getSpeed());
            }
            KATRequest requestObject = new KATRequest(requestPayload, KATEndPoints.baseURL(this.context) + "/config/", null);
            KATPostReqAsync request = new KATPostReqAsync(this.apiToken, new KATRequestDone(){

                @Override
                public void KATRequestSuccess(KATResponse response) {
                    try {
                        String serviceURL;
                        LinkedTreeMap responseMap = (LinkedTreeMap)response.responseObject;
                        if (response.responseObject != null && responseMap.containsKey((Object)"regions")) {
                            KATManager.this.initMonitoring((ArrayList)responseMap.get((Object)"regions"));
                            KATSharedPreferences.setLastConfigUpdateDate(KATManager.this.context, now);
                            KATSharedPreferences.saveConfigResponse(KATManager.this.context, (ArrayList)responseMap.get((Object)"regions"));
                        }
                        HashMap<String, Boolean> concludes = new HashMap<String, Boolean>();
                        if (response.responseObject != null && responseMap.containsKey((Object)"concludes")) {
                            for (String url : (ArrayList)responseMap.get((Object)"concludes")) {
                                if (mKatAudienceManager.isPackageInstalled(url, KATManager.this.context)) {
                                    concludes.put(url, Boolean.TRUE);
                                    continue;
                                }
                                concludes.put(url, Boolean.FALSE);
                            }
                        }
                        mKatAudienceManager.collect(concludes, mLastLocation);
                        if (response.responseObject != null && responseMap.containsKey((Object)"serviceURL") && (serviceURL = (String)responseMap.get((Object)"serviceURL")) != null && serviceURL.startsWith("https://")) {
                            KATSharedPreferences.saveServiceURL(KATManager.this.context, serviceURL);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"GlimrSDK Error", (String)e.getMessage());
                    }
                }

                @Override
                public void KATRequestFailed(int responseCode, String errorMessage) {
                    try {
                        KATSharedPreferences.saveServiceURL(KATManager.this.context, KATEndPoints.fallbackURL());
                        ArrayList config = KATSharedPreferences.getConfigResponse(KATManager.this.context);
                        if (config != null) {
                            KATManager.this.initMonitoring(config);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"GlimrSDK Error", (String)e.getMessage());
                    }
                }
            });
            request.execute(new KATRequest[]{requestObject});
        }
        catch (Exception e) {
            Log.e((String)"GlimrSDK Error", (String)e.getMessage());
        }
    }

    public void stopMonitoring() {
        if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
            mGoogleApiClient.disconnect();
        }
        this.monitoringCallRequested = false;
        this.geotagCallRequested = false;
        mLastLocation = null;
        this.mKatBeaconManager.isApplicationOpen = false;
    }

    public void startMonitoring() {
        if (!KATSystemInformation.isGenerallySupported()) {
            Log.e((String)"GlimrSDK Info", (String)"This call requires >=4.2");
            return;
        }
        this.buildGoogleApiClient();
        if (!(KATSystemInformation.advertId == null || mLastLocation == null && KATSystemInformation.hasLocationPermission(this.context))) {
            this.executeStartMonitoring();
        } else {
            this.monitoringCallRequested = true;
        }
    }

    public void getAudiencesAndGeotags() {
        if (!KATSystemInformation.isGenerallySupported()) {
            Log.e((String)"GlimrSDK Info", (String)"This call requires >=4.2");
            return;
        }
        this.buildGoogleApiClient();
        if (!(KATSystemInformation.advertId == null || mLastLocation == null && KATSystemInformation.hasLocationPermission(this.context))) {
            this.executeAudiencesAndGeotags();
        } else {
            this.geotagCallRequested = true;
        }
    }

    public void trackURL(String url) {
        try {
            mKatAudienceManager.trackURL(url);
        }
        catch (Exception e) {
            Log.e((String)"GlimrSDK Error", (String)e.getMessage());
        }
    }

    private void executeStartMonitoring() {
        this.monitoringCallRequested = false;
        if (KATSystemInformation.advertId != null) {
            this.updateConfig();
            Log.d((String)"GlimrSDK", (String)"startMonitoring");
        } else {
            try {
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KATManager.this.updateConfig();
                        Log.d((String)"GlimrSDK", (String)"startMonitoring delayed");
                    }
                }, (long)KATSystemInformation.advertIdDelay());
            }
            catch (Exception e) {
                Log.e((String)"GlimrSDK Error", (String)e.getMessage());
            }
        }
    }

    private void executeAudiencesAndGeotags() {
        this.geotagCallRequested = false;
        if (KATSystemInformation.advertId != null) {
            mKatAudienceManager.getAudiences(mLastLocation, this.mCallbackContext);
            Log.d((String)"GlimrSDK", (String)"getAudiencesAndGeotags");
        } else {
            try {
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        mKatAudienceManager.getAudiences(mLastLocation, KATManager.this.mCallbackContext);
                        Log.d((String)"GlimrSDK", (String)"getAudiencesAndGeotags delayed");
                    }
                }, (long)KATSystemInformation.advertIdDelay());
            }
            catch (Exception e) {
                Log.e((String)"GlimrSDK Error", (String)e.getMessage());
            }
        }
    }

    public void onConnected(Bundle bundle) {
        Log.d((String)"GlimrSDK", (String)"ApiClient onConnected");
        mLastLocation = this.updatedLocation();
        if (this.geotagCallRequested) {
            this.executeAudiencesAndGeotags();
        }
        if (this.monitoringCallRequested) {
            this.executeStartMonitoring();
        }
    }

    public void onConnectionSuspended(int i) {
        Log.e((String)"GlimrSDK Error", (String)"ApiClient onConnectionSuspended");
        if (this.geotagCallRequested) {
            this.executeAudiencesAndGeotags();
        }
        if (this.monitoringCallRequested) {
            this.executeStartMonitoring();
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        Log.e((String)"GlimrSDK Error", (String)"ApiClient onConnectionFailed");
        if (this.geotagCallRequested) {
            this.executeAudiencesAndGeotags();
        }
        if (this.monitoringCallRequested) {
            this.executeStartMonitoring();
        }
    }

    public void setMockLocation(Location location) {
        mMockLocation = location;
    }

    public void setForceIpOnly(boolean forceIpOnly) {
        KATSystemInformation.setHasForcedIpOnly(forceIpOnly);
    }

    private Location updatedLocation() {
        if (KATSystemInformation.hasForcedIpOnly()) {
            return null;
        }
        if (mMockLocation != null) {
            return mMockLocation;
        }
        if (mGoogleApiClient != null) {
            return LocationServices.FusedLocationApi.getLastLocation(mGoogleApiClient);
        }
        return null;
    }

    static {
        instance = null;
    }
}

