/*
 * Decompiled with CFR 0.152.
 */
package io.glimr.sdk.beacon.service;

import android.util.Log;
import io.glimr.sdk.beacon.service.Callback;
import java.util.Date;

public class MonitorState {
    private static final String TAG = "MonitorState";
    public static long INSIDE_EXPIRATION_MILLIS = 15000L;
    private boolean inside = false;
    private long lastSeenTime = 0L;
    private Callback callback;

    public MonitorState(Callback c) {
        this.callback = c;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public boolean markInside() {
        this.lastSeenTime = new Date().getTime();
        if (!this.inside) {
            this.inside = true;
            return true;
        }
        return false;
    }

    public boolean isNewlyOutside() {
        if (this.inside && this.lastSeenTime > 0L && new Date().getTime() - this.lastSeenTime > INSIDE_EXPIRATION_MILLIS) {
            this.inside = false;
            Log.d((String)TAG, (String)("We are newly outside the region because the lastSeenTime of " + this.lastSeenTime + " was " + (new Date().getTime() - this.lastSeenTime) + " seconds ago, and that is over the expiration duration of  " + INSIDE_EXPIRATION_MILLIS));
            this.lastSeenTime = 0L;
            return true;
        }
        return false;
    }

    public boolean isInside() {
        return this.inside && !this.isNewlyOutside();
    }
}

